/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.organization;

import org.databene.benerator.Generator;
import org.databene.benerator.csv.WeightedDatasetCSVGenerator;
import org.databene.benerator.sample.ConstantGenerator;
import org.databene.benerator.sample.SequencedCSVSampleGenerator;
import org.databene.benerator.util.LightweightGenerator;
import org.databene.benerator.wrapper.AlternativeGenerator;
import org.databene.benerator.wrapper.ConvertingGenerator;
import org.databene.benerator.wrapper.MessageGenerator;
import org.databene.benerator.wrapper.NullableGenerator;
import org.databene.commons.bean.PropertyAccessConverter;
import org.databene.domain.address.CityGenerator;
import org.databene.domain.address.Country;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyNameGenerator
extends LightweightGenerator<String> {
    private static final String ORG = "org/databene/domain/organization/";
    private static final String PERS = "org/databene/domain/person/";
    private static final String REGION = "org/databene/dataset/region";
    private String datasetName;
    private boolean sector;
    private boolean location;
    private boolean legalForm;
    private Generator<String> core;
    private Generator<String> sectorGenerator;
    private Generator<String> legalFormGenerator;
    private Generator<String> locationGenerator;

    public CompanyNameGenerator() {
        this(true, true, true);
    }

    public CompanyNameGenerator(boolean sector, boolean location, boolean legalForm) {
        this(sector, location, legalForm, Country.getDefault().getIsoCode());
    }

    public CompanyNameGenerator(String dataset) {
        this(true, true, true, dataset);
    }

    public CompanyNameGenerator(boolean sector, boolean location, boolean legalForm, String datasetName) {
        super(String.class);
        this.sector = sector;
        this.location = location;
        this.legalForm = legalForm;
        this.datasetName = datasetName;
        this.setDataset(datasetName);
    }

    public void setDataset(String datasetName) {
        Country country = Country.getInstance(datasetName);
        if (this.location && country != null) {
            ConvertingGenerator city = new ConvertingGenerator(new CityGenerator(country), new PropertyAccessConverter("name"));
            this.locationGenerator = new NullableGenerator<String>(new AlternativeGenerator<String>(String.class, new ConstantGenerator<String>(country.getLocalName()), city), 0.8);
        } else {
            this.locationGenerator = new ConstantGenerator<Object>(null);
        }
        if (this.legalForm) {
            this.legalFormGenerator = new WeightedDatasetCSVGenerator<String>("org/databene/domain/organization/legalForm_{0}.csv", datasetName, REGION, "UTF-8");
        }
        if (this.sector) {
            this.sectorGenerator = new NullableGenerator<String>(new WeightedDatasetCSVGenerator("org/databene/domain/organization/sector_{0}.csv", datasetName, REGION, "UTF-8"), 0.7);
        }
        MessageGenerator person = new MessageGenerator("{0} {1}", new WeightedDatasetCSVGenerator("org/databene/domain/person/givenName_male_{0}.csv", datasetName, REGION), new WeightedDatasetCSVGenerator("org/databene/domain/person/familyName_{0}.csv", datasetName, REGION));
        MessageGenerator artificial = new MessageGenerator("{0}{1}", new SequencedCSVSampleGenerator("org/databene/domain/organization/artificial1.csv"), new SequencedCSVSampleGenerator("org/databene/domain/organization/artificial2.csv"));
        MessageGenerator tech = new MessageGenerator("{0}{1}", new SequencedCSVSampleGenerator("org/databene/domain/organization/tech1.csv"), new SequencedCSVSampleGenerator("org/databene/domain/organization/tech2.csv"));
        this.core = new AlternativeGenerator<String>(String.class, artificial, tech, person);
    }

    @Override
    public String generate() {
        String loc;
        String sec;
        StringBuilder builder = new StringBuilder(this.core.generate());
        if (this.sectorGenerator != null && (sec = this.sectorGenerator.generate()) != null) {
            builder.append(' ').append(sec);
        }
        if (this.locationGenerator != null && (loc = this.locationGenerator.generate()) != null) {
            builder.append(' ').append(loc);
        }
        if (this.legalFormGenerator != null) {
            builder.append(' ').append(this.legalFormGenerator.generate());
        }
        return builder.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.datasetName + ']';
    }
}

