/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.person;

import java.util.Calendar;
import java.util.Date;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.primitive.datetime.DateGenerator;
import org.databene.benerator.util.LightweightGenerator;
import org.databene.commons.Period;
import org.databene.commons.TimeUtil;
import org.databene.model.function.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BirthDateGenerator
extends LightweightGenerator<Date> {
    private int minAgeYears;
    private int maxAgeYears;
    private DateGenerator dateGenerator;

    public BirthDateGenerator() {
        this(18, 80);
    }

    public BirthDateGenerator(int minAgeYears, int maxAgeYears) {
        super(Date.class);
        this.minAgeYears = minAgeYears;
        this.maxAgeYears = maxAgeYears;
        Date today = TimeUtil.today().getTime();
        Calendar min = TimeUtil.calendar((Date)today);
        min.add(1, -maxAgeYears);
        Calendar max = TimeUtil.calendar((Date)today);
        max.add(1, -minAgeYears);
        this.dateGenerator = new DateGenerator(min.getTime(), max.getTime(), Period.DAY.getMillis());
        this.dateGenerator.setDistribution(Sequence.RANDOM);
    }

    @Override
    public Date generate() throws IllegalGeneratorStateException {
        return this.dateGenerator.generate();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[minAgeYears=" + this.minAgeYears + ", maxAgeYears=" + this.maxAgeYears + ']';
    }
}

