/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.person;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.ConversionException;
import org.databene.commons.IOUtil;
import org.databene.commons.converter.FixedSourceTypeConverter;
import org.databene.dataset.DatasetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FemaleFamilyNameConverter
extends FixedSourceTypeConverter<String, String> {
    private String[][] mappings;
    private static final Log logger = LogFactory.getLog(FemaleFamilyNameConverter.class);

    public FemaleFamilyNameConverter() {
        this(null);
    }

    public FemaleFamilyNameConverter(String datasetName) {
        super(String.class, String.class);
        ArrayBuilder builder = new ArrayBuilder(String[].class);
        try {
            if (datasetName != null) {
                String[] dataFiles;
                for (String dataFileName : dataFiles = DatasetFactory.getDataFiles("org/databene/domain/person/ffn_{0}.properties", datasetName, "org/databene/dataset/region")) {
                    Map props = IOUtil.readProperties((String)dataFileName);
                    for (Map.Entry entry : props.entrySet()) {
                        builder.append((Object)new String[]{(String)entry.getKey(), (String)entry.getValue()});
                    }
                }
            }
        }
        catch (Exception e) {
            logger.debug((Object)("No female family name conversion defined for dataset '" + datasetName + "'"));
        }
        this.mappings = (String[][])builder.toArray();
    }

    public String convert(String name) throws ConversionException {
        for (String[] mapping : this.mappings) {
            if (mapping[0].length() != 0 && !name.endsWith(mapping[0])) continue;
            return name.substring(0, name.length() - mapping[0].length()) + mapping[1];
        }
        return name;
    }
}

