/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.person;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.util.LightweightGenerator;
import org.databene.commons.Converter;
import org.databene.domain.address.Country;
import org.databene.domain.person.BirthDateGenerator;
import org.databene.domain.person.FamilyNameGenerator;
import org.databene.domain.person.FemaleFamilyNameConverter;
import org.databene.domain.person.Gender;
import org.databene.domain.person.GenderGenerator;
import org.databene.domain.person.GivenNameGenerator;
import org.databene.domain.person.Person;
import org.databene.domain.person.SalutationProvider;
import org.databene.domain.person.TitleGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonGenerator
extends LightweightGenerator<Person> {
    private static Log logger = LogFactory.getLog(PersonGenerator.class);
    private GenderGenerator genderGen;
    private GivenNameGenerator maleGivenNameGen;
    private GivenNameGenerator femaleGivenNameGen;
    private FamilyNameGenerator familyNameGen;
    private Converter<String, String> femaleFamilyNameConverter;
    private TitleGenerator titleGen;
    private SalutationProvider salutationProvider;
    private BirthDateGenerator birthDateGenerator;

    public PersonGenerator() {
        this(Country.getDefault(), Locale.getDefault());
    }

    public PersonGenerator(Country country, Locale locale) {
        this(country.getIsoCode(), locale);
    }

    public PersonGenerator(String datasetName, Locale locale) {
        super(Person.class);
        this.init(datasetName, locale);
    }

    private void init(String datasetName, Locale locale) {
        this.genderGen = new GenderGenerator();
        this.birthDateGenerator = new BirthDateGenerator(15, 105);
        this.titleGen = new TitleGenerator(locale);
        this.salutationProvider = new SalutationProvider(locale);
        this.init(datasetName);
    }

    private void init(String datasetName) {
        try {
            this.maleGivenNameGen = new GivenNameGenerator(datasetName, Gender.MALE);
            this.femaleGivenNameGen = new GivenNameGenerator(datasetName, Gender.FEMALE);
            this.familyNameGen = new FamilyNameGenerator(datasetName);
            this.femaleFamilyNameConverter = new FemaleFamilyNameConverter(datasetName);
        }
        catch (RuntimeException e) {
            Country fallBackCountry = Country.getFallback();
            if (!fallBackCountry.getIsoCode().equals(datasetName)) {
                logger.error((Object)("Cannot generate addresses for " + datasetName + ", falling back to " + fallBackCountry));
                this.init(fallBackCountry.getIsoCode());
            }
            throw e;
        }
    }

    public Locale getLocale() {
        return this.titleGen.getLocale();
    }

    public void setLocale(Locale locale) {
        this.titleGen.setLocale(locale);
        this.salutationProvider.setLocale(locale);
    }

    public String getDataset() {
        return this.familyNameGen.getDataset();
    }

    public void setDataset(String datasetName) {
        this.maleGivenNameGen = new GivenNameGenerator(datasetName, Gender.MALE);
        this.femaleGivenNameGen = new GivenNameGenerator(datasetName, Gender.FEMALE);
        this.familyNameGen = new FamilyNameGenerator(datasetName);
    }

    @Override
    public Person generate() throws IllegalGeneratorStateException {
        Person person = new Person();
        person.setGender(this.genderGen.generate());
        if (Gender.MALE.equals((Object)person.getGender())) {
            person.setGivenName((String)this.maleGivenNameGen.generate());
        } else {
            person.setGivenName((String)this.femaleGivenNameGen.generate());
        }
        String familyName = (String)this.familyNameGen.generate();
        if (Gender.FEMALE.equals((Object)person.getGender())) {
            familyName = (String)this.femaleFamilyNameConverter.convert((Object)familyName);
        }
        person.setFamilyName(familyName);
        person.setSalutation(this.salutationProvider.salutation(person.getGender()));
        person.setTitle((String)this.titleGen.generate());
        person.setBirthDate(this.birthDateGenerator.generate());
        return person;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

