/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.person;

import org.databene.benerator.Generator;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.primitive.number.adapter.IntegerGenerator;
import org.databene.benerator.util.LightweightGenerator;
import org.databene.commons.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSNGenerator_US
extends LightweightGenerator<String> {
    private IntegerGenerator areaNumberGenerator;
    private Generator<Integer> groupNumberGenerator;
    private Generator<Integer> serialNumberGenerator;

    public SSNGenerator_US() {
        this(772);
    }

    public SSNGenerator_US(int maxAreaCode) {
        super(String.class);
        this.areaNumberGenerator = new IntegerGenerator(1, maxAreaCode);
        this.groupNumberGenerator = new IntegerGenerator(1, 99);
        this.serialNumberGenerator = new IntegerGenerator(1, 9999);
    }

    @Override
    public String generate() throws IllegalGeneratorStateException {
        Integer area;
        while ((area = (Integer)this.areaNumberGenerator.generate()) == 666 || area >= 734 && area <= 749) {
        }
        return StringUtil.padLeft((String)String.valueOf(area), (int)3, (char)'0') + '-' + StringUtil.padLeft((String)String.valueOf(this.groupNumberGenerator.generate()), (int)2, (char)'0') + '-' + StringUtil.padLeft((String)String.valueOf(this.serialNumberGenerator.generate()), (int)4, (char)'0');
    }

    public int getMaxAreaCode() {
        return (Integer)this.areaNumberGenerator.getMax();
    }

    public void setMaxAreaCode(int maxAreaCode) {
        this.areaNumberGenerator.setMax(maxAreaCode);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.getMaxAreaCode() + ']';
    }
}

