/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.person;

import org.databene.commons.StringUtil;
import org.databene.commons.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSNValidator_US
implements Validator<String> {
    private int maxAreaCode = 772;

    public boolean valid(String ssn) {
        if (ssn == null || ssn.length() != 11) {
            return false;
        }
        String[] tokens = StringUtil.tokenize((String)ssn, (char)'-');
        if (tokens.length != 3) {
            return false;
        }
        try {
            if (tokens[0].length() != 3) {
                return false;
            }
            int areaNumber = Integer.parseInt(tokens[0]);
            if (areaNumber < 1 || areaNumber == 666 || areaNumber > this.maxAreaCode || areaNumber > 733 && areaNumber < 750) {
                return false;
            }
            if (tokens[1].length() != 2) {
                return false;
            }
            int groupNumber = Integer.parseInt(tokens[1]);
            if (groupNumber < 1) {
                return false;
            }
            if (tokens[2].length() != 4) {
                return false;
            }
            int serialNumber = Integer.parseInt(tokens[2]);
            if (serialNumber < 1) {
                return false;
            }
            if (areaNumber == 987 && areaNumber == 65 && serialNumber >= 4320 && serialNumber <= 4329) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

