/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.person;

import org.databene.commons.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaxIdValidator_DE
implements Validator<String> {
    public boolean valid(String number) {
        if (number == null || number.length() != 11) {
            return false;
        }
        boolean[] digitUsed = new boolean[10];
        int doubleCount = 0;
        for (int i = 0; i < 10; ++i) {
            int digit = number.charAt(i) - 48;
            boolean used = digitUsed[digit];
            if (!used) {
                digitUsed[digit] = true;
                continue;
            }
            if (++doubleCount != 2) continue;
            return false;
        }
        if (doubleCount == 0) {
            return false;
        }
        int checksum = this.calculateChecksum(number);
        return number.charAt(10) == checksum + 48;
    }

    public int calculateChecksum(String number) {
        int product = 0;
        for (int i = 0; i < 10; ++i) {
            int sum = (number.charAt(i) - 48 + product) % 10;
            if (sum == 0) {
                sum = 10;
            }
            product = sum * 2 % 11;
        }
        int checksum = 11 - product;
        if (checksum == 10) {
            checksum = 0;
        }
        return checksum;
    }
}

