/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.product;

import org.databene.benerator.factory.GeneratorFactory;
import org.databene.benerator.wrapper.GeneratorWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EAN13Generator
extends GeneratorWrapper<String, String> {
    private boolean unique;

    public EAN13Generator() {
        this(false);
    }

    public EAN13Generator(boolean unique) {
        super(null);
        this.setUnique(unique);
    }

    private void setUnique(boolean unique) {
        this.unique = unique;
        if (unique) {
            this.setSource(GeneratorFactory.getUniqueRegexStringGenerator("[0-9]{12}", 12, 12, null));
        } else {
            this.setSource(GeneratorFactory.getRegexStringGenerator("[0-9]{12}", 12, 12, null, 0.0));
        }
    }

    @Override
    public Class<String> getGeneratedType() {
        return String.class;
    }

    @Override
    public String generate() {
        char[] chars = new char[13];
        int sum = 0;
        ((String)this.source.generate()).getChars(0, 12, chars, 0);
        for (int i = 0; i < 12; ++i) {
            sum += (chars[i] - 48) * (1 + i % 2 * 2);
        }
        chars[12] = sum % 10 == 0 ? 48 : (char)(58 - sum % 10);
        return new String(chars);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + (this.unique ? "[unique]" : "");
    }
}

