/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.product;

import org.databene.benerator.factory.GeneratorFactory;
import org.databene.benerator.wrapper.GeneratorWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EAN8Generator
extends GeneratorWrapper<String, String> {
    private boolean unique;

    public EAN8Generator() {
        this(false);
    }

    public EAN8Generator(boolean unique) {
        super(null);
        this.setUnique(unique);
    }

    public boolean isUnique() {
        return this.unique;
    }

    private void setUnique(boolean unique) {
        this.unique = unique;
        if (unique) {
            this.setSource(GeneratorFactory.getUniqueRegexStringGenerator("[0-9]{7}", 7, 7, null));
        } else {
            this.setSource(GeneratorFactory.getRegexStringGenerator("[0-9]{7}", 7, 7, null, 0.0));
        }
    }

    @Override
    public Class<String> getGeneratedType() {
        return String.class;
    }

    @Override
    public String generate() {
        char[] chars = new char[8];
        ((String)this.source.generate()).getChars(0, 7, chars, 0);
        chars[7] = chars[6];
        chars[6] = 48;
        int sum = 0;
        for (int i = 0; i < 8; ++i) {
            sum += (chars[i] - 48) * (1 + i % 2 * 2);
        }
        chars[6] = sum % 10 == 0 ? 48 : (char)(58 - sum % 10);
        return new String(chars);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + (this.unique ? "[unique]" : "");
    }
}

