/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.product;

import org.databene.benerator.wrapper.AlternativeGenerator;
import org.databene.benerator.wrapper.GeneratorProxy;
import org.databene.benerator.wrapper.UniqueAlternativeGenerator;
import org.databene.domain.product.EAN13Generator;
import org.databene.domain.product.EAN8Generator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EANGenerator
extends GeneratorProxy<String> {
    private boolean unique;
    private boolean dirty;

    public EANGenerator() {
        this(false);
    }

    public EANGenerator(boolean unique) {
        super(null);
        this.unique = unique;
        this.dirty = true;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
        this.dirty = true;
    }

    @Override
    public Class<String> getGeneratedType() {
        return String.class;
    }

    @Override
    public void validate() {
        if (this.dirty) {
            if (this.unique) {
                super.setSource(new UniqueAlternativeGenerator<String>(String.class, new EAN8Generator(true), new EAN13Generator(true)));
            } else {
                super.setSource(new AlternativeGenerator<String>(String.class, new EAN8Generator(false), new EAN13Generator(false)));
            }
            super.validate();
            this.dirty = false;
        }
    }

    @Override
    public boolean available() {
        if (this.dirty) {
            this.validate();
        }
        return super.available();
    }

    @Override
    public String generate() {
        if (this.dirty) {
            this.validate();
        }
        return (String)super.generate();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + (this.unique ? "[unique]" : "");
    }
}

