/*
 * Decompiled with CFR 0.152.
 */
package org.databene.id;

import java.util.HashMap;
import java.util.Map;
import org.databene.commons.CollectionUtil;
import org.databene.id.IdProvider;
import org.databene.id.IdProviderFactory;
import org.databene.id.IdStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIdProviderFactory
implements IdProviderFactory {
    private Map<String, IdProvider> providers = new HashMap<String, IdProvider>();

    @Override
    public <T> IdProvider<T> idProvider(IdStrategy<T> strategy, String param, String scope) {
        if (scope == null || "local".equals(scope)) {
            return this.createIdProvider(strategy, param);
        }
        IdProvider<T> provider = this.providers.get(scope);
        if (provider == null) {
            provider = this.createIdProvider(strategy, param);
            this.providers.put(scope, provider);
        }
        return provider;
    }

    public abstract <T> IdProvider<T> createIdProvider(IdStrategy<T> var1, String var2);

    @Override
    public IdStrategy<? extends Object>[] getIdStrategies() {
        return (IdStrategy[])CollectionUtil.toArray(this.providers.values());
    }
}

