/*
 * Decompiled with CFR 0.152.
 */
package org.databene.id;

import org.databene.commons.ConfigurationError;
import org.databene.id.AbstractIdProviderFactory;
import org.databene.id.IdProvider;
import org.databene.id.IdStrategy;
import org.databene.id.IncrementIdProvider;
import org.databene.id.UUIDProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalIdProviderFactory
extends AbstractIdProviderFactory {
    public static final IdStrategy<String> UUID = new IdStrategy<String>("uuid", String.class);
    public static final IdStrategy<Long> INCREMENT = new IdStrategy<Long>("increment", Long.class);
    public static final UUIDProvider uuidProvider = new UUIDProvider();

    @Override
    public <T> IdProvider<T> createIdProvider(IdStrategy<T> strategy, String param) {
        if (strategy == INCREMENT) {
            return this.createIncrementIdProvider(param);
        }
        if (strategy == UUID) {
            return uuidProvider;
        }
        throw new ConfigurationError("IdStrategy '" + strategy + "' is not supported by " + this.getClass().getName());
    }

    @Override
    public IdStrategy<? extends Object>[] getIdStrategies() {
        return new IdStrategy[]{INCREMENT, UUID};
    }

    private IncrementIdProvider createIncrementIdProvider(String param) {
        long initialValue = 1L;
        if (param != null) {
            initialValue = Long.parseLong(param);
        }
        return new IncrementIdProvider(initialValue);
    }
}

