/*
 * Decompiled with CFR 0.152.
 */
package org.databene.measure.count;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectCounter<E> {
    private Map<E, AtomicInteger> instances;
    long totalCount;

    public ObjectCounter(int initialCapacity) {
        this.instances = new HashMap<E, AtomicInteger>(initialCapacity);
        this.totalCount = 0L;
    }

    public void count(E instance) {
        AtomicInteger counter = this.instances.get(instance);
        if (counter == null) {
            this.instances.put(instance, new AtomicInteger(1));
        } else {
            counter.incrementAndGet();
        }
        ++this.totalCount;
    }

    public Set<E> objectSet() {
        return this.instances.keySet();
    }

    public int getCount(E instance) {
        AtomicInteger counter = this.instances.get(instance);
        return counter != null ? counter.intValue() : 0;
    }

    public double averageCount() {
        return this.totalCount / (long)this.instances.size();
    }

    public boolean equalDistribution(double tolerance) {
        double average = this.averageCount();
        Collection<AtomicInteger> counts = this.instances.values();
        for (AtomicInteger count : counts) {
            if (!(Math.abs((count.doubleValue() - average) / average) > tolerance)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        Map.Entry<E, AtomicInteger> entry;
        StringBuilder buffer = new StringBuilder("[");
        Iterator<Map.Entry<E, AtomicInteger>> iterator = this.instances.entrySet().iterator();
        if (iterator.hasNext()) {
            entry = iterator.next();
            buffer.append(entry.getKey()).append(':').append(entry.getValue());
        }
        while (iterator.hasNext()) {
            entry = iterator.next();
            buffer.append(", ").append(entry.getKey()).append(':').append(entry.getValue());
        }
        buffer.append(']');
        return buffer.toString();
    }
}

