/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.consumer;

import java.util.List;
import org.databene.commons.CollectionUtil;
import org.databene.model.consumer.AbstractConsumer;
import org.databene.model.consumer.Consumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerChain<E>
extends AbstractConsumer<E> {
    private List<Consumer<E>> components;

    public ConsumerChain(Consumer<E> ... components) {
        this.setComponents(components);
    }

    public void setComponents(Consumer<E> ... components) {
        this.components = CollectionUtil.toList((Object[])components);
    }

    public void addComponent(Consumer<E> component) {
        this.components.add(component);
    }

    public Consumer<E> getComponent(int index) {
        return this.components.get(index);
    }

    public int componentCount() {
        return this.components.size();
    }

    @Override
    public void startConsuming(E object) {
        for (Consumer<E> processor : this.components) {
            processor.startConsuming(object);
        }
    }

    @Override
    public void finishConsuming(E object) {
        for (Consumer<E> processor : this.components) {
            processor.finishConsuming(object);
        }
    }

    @Override
    public void flush() {
        for (Consumer<E> processor : this.components) {
            processor.flush();
        }
    }

    @Override
    public void close() {
        for (Consumer<E> processor : this.components) {
            processor.close();
        }
    }

    public List<Consumer<E>> getComponents() {
        return this.components;
    }
}

