/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.consumer;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ConfigurationError;
import org.databene.commons.IOUtil;
import org.databene.commons.SystemInfo;
import org.databene.model.consumer.FileExporter;
import org.databene.model.consumer.FormattingConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFileExporter<E>
extends FormattingConsumer<E>
implements FileExporter<E> {
    private static final String DEFAULT_ENCODING = SystemInfo.getFileEncoding();
    private static final String DEFAULT_LINE_SEPARATOR = SystemInfo.getLineSeparator();
    protected String uri;
    protected String encoding;
    protected String lineSeparator;
    protected boolean append;
    protected PrintWriter printer;

    public TextFileExporter() {
        this(null, null, null);
    }

    public TextFileExporter(String uri) {
        this(uri, null, null);
    }

    public TextFileExporter(String uri, String encoding, String lineSeparator) {
        this.uri = uri != null ? uri : "export.txt";
        this.encoding = encoding != null ? encoding : DEFAULT_ENCODING;
        this.lineSeparator = lineSeparator != null ? lineSeparator : DEFAULT_LINE_SEPARATOR;
        this.append = false;
    }

    protected void postInitPrinter() {
    }

    protected void startConsumingImpl(E data) {
        this.printer.println(this.plainConverter.convert(data));
    }

    private void preClosePrinter() {
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    @Override
    public void startConsuming(E data) {
        try {
            if (this.printer == null) {
                this.initPrinter();
            }
            this.startConsumingImpl(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void flush() {
        if (this.printer != null) {
            this.printer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.printer == null) {
                this.initPrinter();
            }
            this.preClosePrinter();
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).error((Object)e, (Throwable)e);
        }
        finally {
            if (this.printer != null) {
                this.printer.close();
            }
        }
    }

    protected void initPrinter() throws IOException {
        if (this.uri == null) {
            throw new ConfigurationError("Property 'uri' not set on bean " + this.getClass().getName());
        }
        this.printer = IOUtil.getPrinterForURI((String)this.uri, (String)this.encoding, (boolean)this.append, (String)this.lineSeparator);
        this.postInitPrinter();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.uri + "]";
    }
}

