/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.data;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.databene.commons.collection.ListBasedSet;
import org.databene.commons.collection.NamedValueList;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.model.data.ComponentDescriptor;
import org.databene.model.data.InstanceDescriptor;
import org.databene.model.data.TypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexTypeDescriptor
extends TypeDescriptor {
    public static final String __SIMPLE_CONTENT = "__SIMPLE_CONTENT";
    private NamedValueList<ComponentDescriptor> components;
    private Map<String, InstanceDescriptor> variables;

    public ComplexTypeDescriptor(String name) {
        this(name, (String)null);
    }

    public ComplexTypeDescriptor(String name, ComplexTypeDescriptor parent) {
        super(name, parent);
        this.init();
    }

    public ComplexTypeDescriptor(String name, String parentName) {
        super(name, parentName);
        this.init();
    }

    public void addComponent(ComponentDescriptor descriptor) {
        String componentName = descriptor.getName();
        if (this.parent != null && ((ComplexTypeDescriptor)this.parent).getComponent(componentName) != null) {
            descriptor.setParent(((ComplexTypeDescriptor)this.parent).getComponent(componentName));
        }
        this.components.add(componentName, (Object)descriptor);
    }

    public void setComponent(ComponentDescriptor component) {
        String componentName = component.getName();
        if (this.parent != null && ((ComplexTypeDescriptor)this.parent).getComponent(componentName) != null) {
            component.setParent(((ComplexTypeDescriptor)this.parent).getComponent(componentName));
        }
        this.components.set(componentName, (Object)component);
    }

    public ComponentDescriptor getComponent(String name) {
        ComponentDescriptor descriptor = (ComponentDescriptor)this.components.someValueOfName(name);
        if (descriptor == null && this.getParent() != null) {
            descriptor = ((ComplexTypeDescriptor)this.getParent()).getComponent(name);
        }
        return descriptor;
    }

    public List<ComponentDescriptor> getComponents() {
        NamedValueList result = NamedValueList.createCaseInsensitiveList();
        for (ComponentDescriptor ccd : this.components.values()) {
            result.add(ccd.getName(), (Object)ccd);
        }
        if (this.getParent() != null) {
            NamedValueList<ComponentDescriptor> parentComponents = ((ComplexTypeDescriptor)this.getParent()).components;
            for (ComponentDescriptor pcd : parentComponents.values()) {
                String name = pcd.getName();
                if (this.components.containsName(name)) continue;
                ComponentDescriptor ccd = (ComponentDescriptor)this.components.someValueOfName(name);
                if (ccd != null) {
                    result.add(name, (Object)ccd);
                    continue;
                }
                result.add(name, (Object)pcd);
            }
        }
        return result.values();
    }

    public Collection<ComponentDescriptor> getDeclaredComponents() {
        ListBasedSet declaredDescriptors = new ListBasedSet(this.components.size());
        for (ComponentDescriptor d : this.components.values()) {
            declaredDescriptors.add(d);
        }
        return declaredDescriptors;
    }

    public boolean isDeclaredComponent(String componentName) {
        return this.components.containsName(componentName);
    }

    public Collection<InstanceDescriptor> getVariables() {
        return this.variables.values();
    }

    public void addVariable(InstanceDescriptor variable) {
        this.variables.put(variable.getName(), variable);
    }

    public ComplexTypeDescriptor withComponent(ComponentDescriptor componentDescriptor) {
        this.addComponent(componentDescriptor);
        return this;
    }

    @Override
    protected void init() {
        super.init();
        this.components = new NamedValueList(1);
        this.variables = new OrderedNameMap();
    }

    @Override
    public String toString() {
        if (this.components.size() == 0) {
            return super.toString();
        }
        return this.getName() + this.getComponents().toString();
    }
}

