/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.data;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ConfigurationError;
import org.databene.model.data.BasicDescriptorProvider;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.ComponentDescriptor;
import org.databene.model.data.DescriptorProvider;
import org.databene.model.data.PrimitiveType;
import org.databene.model.data.SimpleTypeDescriptor;
import org.databene.model.data.TypeDescriptor;

public class DataModel {
    private Log logger = LogFactory.getLog(DataModel.class);
    private static final DataModel defaultInstance = new DataModel();
    private Map<String, DescriptorProvider> providers = new HashMap<String, DescriptorProvider>();

    public DataModel() {
        this.clear();
    }

    public void addDescriptorProvider(DescriptorProvider provider) {
        this.addDescriptorProvider(provider, true);
    }

    public void addDescriptorProvider(DescriptorProvider provider, boolean validate) {
        this.providers.put(provider.getId(), provider);
        if (validate) {
            this.validate();
        }
    }

    public TypeDescriptor getTypeDescriptor(String typeId) {
        if (typeId == null) {
            return null;
        }
        String namespace = null;
        String name = typeId;
        if (typeId.contains(":")) {
            int i = typeId.indexOf(58);
            namespace = typeId.substring(0, i);
            name = typeId.substring(i + 1);
        }
        return this.getTypeDescriptor(namespace, name);
    }

    public TypeDescriptor getTypeDescriptor(String namespace, String name) {
        TypeDescriptor descriptor;
        DescriptorProvider provider;
        if (name == null) {
            return null;
        }
        if (namespace != null && (provider = this.providers.get(namespace)) != null) {
            TypeDescriptor typeDescriptor = provider.getTypeDescriptor(name);
            if (typeDescriptor != null) {
                return typeDescriptor;
            }
            return this.searchCaseInsensitive(provider, name);
        }
        for (DescriptorProvider provider2 : this.providers.values()) {
            descriptor = provider2.getTypeDescriptor(name);
            if (descriptor == null) continue;
            return descriptor;
        }
        for (DescriptorProvider provider2 : this.providers.values()) {
            descriptor = this.searchCaseInsensitive(provider2, name);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    public void validate() {
        for (DescriptorProvider provider : this.providers.values()) {
            for (TypeDescriptor desc : provider.getTypeDescriptors()) {
                this.validate(desc);
            }
        }
    }

    public static DataModel getDefaultInstance() {
        return defaultInstance;
    }

    private TypeDescriptor searchCaseInsensitive(DescriptorProvider provider, String name) {
        for (TypeDescriptor type : provider.getTypeDescriptors()) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    private void validate(TypeDescriptor type) {
        this.logger.debug((Object)("validating " + type));
        if (type instanceof SimpleTypeDescriptor) {
            this.validate((SimpleTypeDescriptor)type);
        } else if (type instanceof ComplexTypeDescriptor) {
            this.validate((ComplexTypeDescriptor)type);
        } else {
            throw new UnsupportedOperationException("Descriptor type not supported: " + type.getClass());
        }
    }

    private void validate(ComplexTypeDescriptor desc) {
        for (ComponentDescriptor component : desc.getComponents()) {
            TypeDescriptor type = component.getType();
            if (type instanceof ComplexTypeDescriptor) continue;
            this.validate(type);
        }
    }

    private void validate(SimpleTypeDescriptor desc) {
        PrimitiveType primitiveType = desc.getPrimitiveType();
        if (primitiveType == null) {
            throw new ConfigurationError("No primitive type defined for simple type: " + desc.getName());
        }
    }

    public void clear() {
        this.providers.clear();
        this.addDescriptorProvider(new BasicDescriptorProvider(), false);
    }
}

