/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.data;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.CollectionUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.commons.xml.XMLUtil;
import org.databene.model.data.DescriptorProvider;
import org.databene.model.data.TypeDescriptor;

public class DefaultDescriptorProvider
implements DescriptorProvider {
    private static Log logger = LogFactory.getLog(DefaultDescriptorProvider.class);
    protected Map<String, TypeDescriptor> typeMap = new OrderedNameMap();
    protected String id;
    private boolean redefinable;

    public DefaultDescriptorProvider(String id) {
        this(id, false);
    }

    public DefaultDescriptorProvider(String id, boolean redefinable) {
        this.id = id;
        this.redefinable = redefinable;
    }

    protected void addDescriptor(TypeDescriptor descriptor) {
        if (!this.redefinable && this.typeMap.get(descriptor.getName()) != null) {
            throw new ConfigurationError("Type has already been defined: " + descriptor.getName());
        }
        this.typeMap.put(descriptor.getName(), descriptor);
        logger.debug((Object)("added " + descriptor.getClass().getSimpleName() + ": " + descriptor));
    }

    public String getId() {
        return this.id;
    }

    public TypeDescriptor getTypeDescriptor(String typeName) {
        String localName = XMLUtil.localName((String)typeName);
        return this.typeMap.get(localName);
    }

    public TypeDescriptor[] getTypeDescriptors() {
        return (TypeDescriptor[])CollectionUtil.toArray(this.typeMap.values(), TypeDescriptor.class);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.id + ')';
    }
}

