/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.data;

import java.util.Map;
import org.databene.commons.Composite;
import org.databene.commons.CompositeFormatter;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.commons.converter.AnyConverter;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.ComponentDescriptor;
import org.databene.model.data.PrimitiveType;
import org.databene.model.data.SimpleTypeDescriptor;
import org.databene.platform.bean.BeanDescriptorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entity
implements Composite<Object> {
    private static final BeanDescriptorProvider BEAN_DESCRIPTOR_PROVIDER = new BeanDescriptorProvider();
    private OrderedNameMap<Object> components;
    private ComplexTypeDescriptor descriptor;

    public Entity(String name, Object ... componentKeyValuePairs) {
        this(new ComplexTypeDescriptor(name), componentKeyValuePairs);
    }

    public Entity(ComplexTypeDescriptor descriptor, Object ... componentKeyValuePairs) {
        this.descriptor = descriptor;
        this.components = OrderedNameMap.createCaseInsensitiveMap();
        for (int i = 0; i < componentKeyValuePairs.length; i += 2) {
            this.setComponent((String)componentKeyValuePairs[i], componentKeyValuePairs[i + 1]);
        }
    }

    public String getName() {
        return this.descriptor != null ? this.descriptor.getName() : null;
    }

    public ComplexTypeDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Object get(String componentName) {
        return this.getComponent(componentName);
    }

    public Object getComponent(String componentName) {
        return this.components.get(componentName);
    }

    public boolean componentIsSet(String componentName) {
        return this.components.containsKey(componentName);
    }

    public Map<String, Object> getComponents() {
        return this.components;
    }

    public void set(String componentName, Object component) {
        this.setComponent(componentName, component);
    }

    public void setComponent(String componentName, Object component) {
        ComponentDescriptor componentDescriptor = this.descriptor.getComponent(componentName);
        if (componentDescriptor != null && componentDescriptor.getType() instanceof SimpleTypeDescriptor) {
            SimpleTypeDescriptor componentType = (SimpleTypeDescriptor)componentDescriptor.getType();
            PrimitiveType primitiveType = componentType.getPrimitiveType();
            if (primitiveType == null) {
                primitiveType = PrimitiveType.STRING;
            }
            Class<? extends Object> javaType = BEAN_DESCRIPTOR_PROVIDER.concreteType(primitiveType.getName());
            component = AnyConverter.convert((Object)component, javaType);
        }
        String internalComponentName = componentDescriptor != null ? componentDescriptor.getName() : componentName;
        this.components.put(internalComponentName, component);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity that = (Entity)o;
        if (!this.descriptor.getName().equals(that.descriptor.getName())) {
            return false;
        }
        return this.components.equalsIgnoreOrder(that.components);
    }

    public int hashCode() {
        return this.descriptor.hashCode() * 29 + this.components.hashCode();
    }

    public String toString() {
        return new CompositeFormatter(true, true).render(this.getName() + '[', (Composite)this, "]");
    }
}

