/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.data;

import java.util.List;
import org.databene.commons.Converter;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.Operation;
import org.databene.commons.StringUtil;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.commons.converter.AnyConverter;
import org.databene.commons.converter.ConverterManager;
import org.databene.commons.converter.String2ConverterConverter;
import org.databene.commons.converter.ToStringConverter;
import org.databene.model.data.FeatureDetail;
import org.databene.model.function.String2DistributionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureDescriptor {
    public static final String NAME = "name";
    protected OrderedNameMap<FeatureDetail<? extends Object>> details = new OrderedNameMap();

    public FeatureDescriptor(String name) {
        this.addRestriction(NAME, String.class, null, null);
        this.setName(name);
    }

    public String getName() {
        return (String)this.getDetailValue(NAME);
    }

    public void setName(String name) {
        this.setDetailValue(NAME, name);
    }

    public boolean supportsDetail(String name) {
        return this.details.get(name) != null;
    }

    public Object getDeclaredDetailValue(String name) {
        return this.getDetail(name).getValue();
    }

    public Object getDetailValue(String name) {
        FeatureDetail detail = this.getDetail(name);
        Object value = detail.getValue();
        return value;
    }

    public <T> void setDetailValue(String detailName, T detailValue) {
        FeatureDetail<T> detail = this.getDetail(detailName);
        if (detail == null) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support detail type: " + detailName);
        }
        detail.setValue(AnyConverter.convert(detailValue, detail.getType()));
    }

    public <T> void setDetailValueAsString(String detailName, String detailValue) {
        FeatureDetail<T> detail = this.getDetail(detailName);
        if (detail == null) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support detail type: " + detailName);
        }
        detail.setValueAsString(detailValue);
    }

    public <T> T getDetailDefault(String name) {
        FeatureDetail<T> detail = this.getDetail(name);
        return detail.getDefault();
    }

    public List<FeatureDetail<? extends Object>> getDetails() {
        return this.details.values();
    }

    public String toString() {
        String name = this.getName();
        if (StringUtil.isEmpty((String)name)) {
            name = "anonymous";
        }
        StringBuilder buffer = new StringBuilder(name).append("[");
        boolean empty = true;
        for (FeatureDetail descriptor : this.details.values()) {
            if (descriptor.getValue() == null || NAME.equals(descriptor.getName())) continue;
            if (!empty) {
                buffer.append(", ");
            }
            empty = false;
            buffer.append(descriptor.getName()).append("=");
            buffer.append(ToStringConverter.convert(descriptor.getValue(), (String)"[null]"));
        }
        return buffer.append("]").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureDescriptor that = (FeatureDescriptor)o;
        for (FeatureDetail detail : this.details.values()) {
            String detailName = detail.getName();
            if (NullSafeComparator.equals(detail.getValue(), (Object)that.getDetailValue(detailName))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getClass().hashCode() * 29 * 29 + this.details.hashCode();
    }

    protected Class<? extends Object> getDetailType(String detailName) {
        FeatureDetail detail = (FeatureDetail)this.details.get(detailName);
        if (detail == null) {
            throw new UnsupportedOperationException("Feature detail not supported: " + detailName);
        }
        return detail.getType();
    }

    protected <T> void addConfig(String name, Class<T> type, T defaultValue) {
        this.addConfig(name, type, defaultValue, false);
    }

    protected <T> void addConfig(String name, Class<T> type, T defaultValue, boolean deprecated) {
        this.addDetail(name, type, false, defaultValue, deprecated, (Converter<String, T>)new AnyConverter(type), null);
    }

    protected <T> void addRestriction(String name, Class<T> type, T defaultValue, Operation<T, T> combinator) {
        this.addDetail(name, type, true, defaultValue, false, null, combinator);
    }

    protected <T> void addDetail(String detailName, Class<T> detailType, boolean constraint, T defaultValue, boolean deprecated, Converter<String, T> converter, Operation<T, T> combinator) {
        this.details.put(detailName, new FeatureDetail<T>(detailName, detailType, constraint, defaultValue, converter, combinator));
    }

    protected <T> FeatureDetail<T> getDetail(String name) {
        FeatureDetail detail = (FeatureDetail)this.details.get(name);
        if (detail == null) {
            throw new UnsupportedOperationException("Feature detail '" + name + "' not supported in feature type: " + this.getClass().getName());
        }
        return detail;
    }

    static {
        ConverterManager converterManager = ConverterManager.getInstance();
        converterManager.register((Converter)new String2DistributionConverter());
        converterManager.register((Converter)new String2ConverterConverter());
    }
}

