/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.data;

import org.databene.commons.Converter;
import org.databene.commons.Escalator;
import org.databene.commons.LoggerEscalator;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.Operation;
import org.databene.commons.converter.AnyConverter;
import org.databene.commons.operation.FirstArgSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureDetail<E> {
    private static Escalator escalator = new LoggerEscalator();
    private String name;
    private Class<E> type;
    private E value;
    private E defaultValue;
    private Converter<String, E> converter;
    private Operation<E, E> combinator;
    private boolean restriction;
    private boolean deprecated;

    public FeatureDetail(String name, Class<E> type, boolean restriction, E defaultValue) {
        this(name, type, restriction, defaultValue, (Converter<String, E>)new AnyConverter(type));
    }

    public FeatureDetail(String name, Class<E> type, boolean restriction, E defaultValue, Converter<String, E> converter) {
        this(name, type, restriction, defaultValue, converter, (Operation<E, E>)new FirstArgSelector());
    }

    public FeatureDetail(String name, Class<E> type, boolean restriction, E defaultValue, Converter<String, E> converter, Operation<E, E> combinator) {
        this(name, type, restriction, defaultValue, converter, combinator, false);
    }

    public FeatureDetail(String name, Class<E> type, boolean restriction, E defaultValue, Converter<String, E> converter, Operation<E, E> combinator, boolean deprecated) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.value = null;
        this.restriction = restriction;
        this.combinator = combinator;
        this.converter = converter;
        this.deprecated = deprecated;
    }

    public String getName() {
        return this.name;
    }

    public Class<E> getType() {
        return this.type;
    }

    public E getValue() {
        return this.value;
    }

    public void setValue(E value) {
        if (this.deprecated && value != null) {
            escalator.escalate("Feature '" + this.name + "' is deprecated", this.getClass(), value);
        }
        if (value != null && !this.type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Tried to assign a value of type '" + value.getClass().getName() + "'to detail '" + this.name + "' of type '" + this.type + "'");
        }
        this.value = value;
    }

    public void setValueAsString(String value) {
        this.value = this.converter.convert((Object)value);
    }

    public E getDefault() {
        return this.defaultValue;
    }

    public E combineWith(E otherValue) {
        return (E)this.combinator.perform(new Object[]{this.value, otherValue});
    }

    public boolean isRestriction() {
        return this.restriction;
    }

    public String getDescription() {
        return this.name + '=' + this.value + " (" + this.type + ')';
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String toString() {
        return this.name + '=' + this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureDetail that = (FeatureDetail)o;
        return this.name.equals(that.name) && NullSafeComparator.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 29 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

