/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.data;

import org.databene.commons.operation.AndOperation;
import org.databene.commons.operation.MaxOperation;
import org.databene.commons.operation.MinOperation;
import org.databene.commons.operation.OrOperation;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.DataModel;
import org.databene.model.data.FeatureDescriptor;
import org.databene.model.data.FeatureDetail;
import org.databene.model.data.SimpleTypeDescriptor;
import org.databene.model.data.TypeDescriptor;
import org.databene.model.function.Distribution;

public class InstanceDescriptor
extends FeatureDescriptor {
    public static final String TYPE = "type";
    public static final String UNIQUE = "unique";
    public static final String NULLABLE = "nullable";
    public static final String MIN_COUNT = "minCount";
    public static final String MAX_COUNT = "maxCount";
    public static final String COUNT_DISTRIBUTION = "countDistribution";
    public static final String COUNT_VARIATION1 = "countVariation1";
    public static final String COUNT_VARIATION2 = "countVariation2";
    public static final String COUNT = "count";
    public static final String NULL_QUOTA = "nullQuota";
    private InstanceDescriptor parent;
    private String typeName;
    private TypeDescriptor localType;

    public InstanceDescriptor(String name) {
        this(name, null, null);
    }

    public InstanceDescriptor(String name, String typeName) {
        this(name, typeName, null);
    }

    public InstanceDescriptor(String name, TypeDescriptor localType) {
        this(name, null, localType);
    }

    protected InstanceDescriptor(String name, String typeName, TypeDescriptor localType) {
        super(name);
        this.typeName = typeName;
        this.localType = localType;
        this.addRestriction(UNIQUE, Boolean.class, false, new OrOperation());
        this.addRestriction(NULLABLE, Boolean.class, false, new AndOperation());
        this.addRestriction(MIN_COUNT, Long.class, null, new MaxOperation());
        this.addRestriction(MAX_COUNT, Long.class, null, new MinOperation());
        this.addConfig(COUNT, Long.class, null);
        this.addConfig(COUNT_DISTRIBUTION, Distribution.class, null);
        this.addConfig(COUNT_VARIATION1, Long.class, null);
        this.addConfig(COUNT_VARIATION2, Long.class, null);
        this.addConfig(NULL_QUOTA, Double.class, null);
    }

    public void setParent(InstanceDescriptor parent) {
        this.parent = parent;
    }

    public String getTypeName() {
        return this.typeName == null && this.parent != null ? this.parent.getTypeName() : this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public TypeDescriptor getType() {
        if (this.getLocalType() != null) {
            return this.getLocalType();
        }
        TypeDescriptor type = null;
        if (this.getTypeName() != null) {
            type = DataModel.getDefaultInstance().getTypeDescriptor(this.typeName);
        }
        return type;
    }

    public TypeDescriptor getLocalType() {
        if (this.localType == null && this.parent != null && this.parent.getLocalType() != null) {
            this.localType = this.getLocalType(this.parent.getLocalType() instanceof ComplexTypeDescriptor);
        }
        return this.localType;
    }

    public TypeDescriptor getLocalType(boolean complexType) {
        if (this.localType != null) {
            return this.localType;
        }
        this.localType = complexType ? new ComplexTypeDescriptor(this.getName(), this.getTypeName()) : new SimpleTypeDescriptor(this.getName(), this.getTypeName());
        this.typeName = null;
        return this.localType;
    }

    public void setLocalType(TypeDescriptor localType) {
        this.localType = localType;
        if (localType != null) {
            this.typeName = null;
        }
    }

    public Boolean isUnique() {
        return (Boolean)this.getDetailValue(UNIQUE);
    }

    public void setUnique(Boolean unique) {
        this.setDetailValue(UNIQUE, unique);
    }

    public Boolean isNullable() {
        return (Boolean)this.getDetailValue(NULLABLE);
    }

    public void setNullable(Boolean nullable) {
        this.setDetailValue(NULLABLE, nullable);
    }

    public Long getMinCount() {
        return (Long)this.getDetailValue(MIN_COUNT);
    }

    public void setMinCount(Long minCount) {
        this.setDetailValue(MIN_COUNT, minCount);
    }

    public Long getMaxCount() {
        return (Long)this.getDetailValue(MAX_COUNT);
    }

    public void setMaxCount(Long maxCount) {
        this.setDetailValue(MAX_COUNT, maxCount);
    }

    public Long getCount() {
        return (Long)this.getDetailValue(COUNT);
    }

    public void setCount(Long count) {
        this.setDetailValue(COUNT, count);
    }

    public Distribution getCountDistribution() {
        return (Distribution)this.getDetailValue(COUNT_DISTRIBUTION);
    }

    public void setCountDistribution(Distribution distribution) {
        this.setDetailValue(COUNT_DISTRIBUTION, distribution);
    }

    public Long getCountVariation1() {
        return (Long)this.getDetailValue(COUNT_VARIATION1);
    }

    public void setCountVariation1(Long countVariation1) {
        this.setDetailValue(COUNT_VARIATION1, countVariation1);
    }

    public Long getCountVariation2() {
        return (Long)this.getDetailValue(COUNT_VARIATION2);
    }

    public void setCountVariation2(Long countVariation2) {
        this.setDetailValue(COUNT_VARIATION2, countVariation2);
    }

    public Double getNullQuota() {
        return (Double)this.getDetailValue(NULL_QUOTA);
    }

    public void setNullQuota(Double nullQuota) {
        this.setDetailValue(NULL_QUOTA, nullQuota);
    }

    public Object getDetailValue(String name) {
        FeatureDetail detail;
        Object value = super.getDetailValue(name);
        if (value == null && this.parent != null && this.parent.supportsDetail(name) && (detail = this.parent.getDetail(name)).isRestriction()) {
            value = detail.getValue();
        }
        if (value == null) {
            value = this.getDetailDefault(name);
        }
        return value;
    }

    public InstanceDescriptor withCount(long count) {
        this.setCount(count);
        return this;
    }

    public InstanceDescriptor withMinCount(long minCount) {
        this.setMinCount(minCount);
        return this;
    }

    public InstanceDescriptor withMaxCount(long maxCount) {
        this.setMaxCount(maxCount);
        return this;
    }

    public InstanceDescriptor withNullQuota(double nullQuota) {
        this.setNullQuota(nullQuota);
        return this;
    }

    public InstanceDescriptor withUnique(boolean unique) {
        this.setUnique(unique);
        return this;
    }

    public boolean overwritesParent() {
        return this.parent != null;
    }
}

