/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.data;

import org.databene.commons.operation.FirstArgSelector;
import org.databene.commons.operation.MaxNumberLiteral;
import org.databene.commons.operation.MaxOperation;
import org.databene.commons.operation.MinNumberLiteral;
import org.databene.commons.operation.MinOperation;
import org.databene.model.data.PrimitiveType;
import org.databene.model.data.TypeDescriptor;

public class SimpleTypeDescriptor
extends TypeDescriptor {
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String MIN_EXCLUSIVE = "minExclusive";
    public static final String MAX_EXCLUSIVE = "maxExclusive";
    public static final String TOTAL_DIGITS = "totalDigits";
    public static final String FRACTION_DIGITS = "fractionDigits";
    public static final String PRECISION = "precision";
    public static final String TRUE_QUOTA = "trueQuota";
    public static final String MIN_LENGTH = "minLength";
    public static final String MAX_LENGTH = "maxLength";
    public static final String LENGTH_DISTRIBUTION = "lengthDistribution";
    private PrimitiveType primitiveType = null;

    public SimpleTypeDescriptor(String name) {
        this(name, (String)null);
    }

    public SimpleTypeDescriptor(String name, SimpleTypeDescriptor parent) {
        this(name, parent.getName());
        this.parent = parent;
    }

    public SimpleTypeDescriptor(String name, String parentName) {
        super(name, parentName);
        this.addRestriction(MIN, String.class, "1", new MaxNumberLiteral());
        this.addRestriction(MAX, String.class, "9", new MinNumberLiteral());
        this.addRestriction(MIN_EXCLUSIVE, String.class, "0", new MaxNumberLiteral());
        this.addRestriction(MAX_EXCLUSIVE, String.class, "10", new MinNumberLiteral());
        this.addRestriction(TOTAL_DIGITS, String.class, "10", new FirstArgSelector());
        this.addRestriction(FRACTION_DIGITS, String.class, "0", new FirstArgSelector());
        this.addConfig(PRECISION, String.class, "1");
        this.addConfig(TRUE_QUOTA, Double.class, 0.5);
        this.addRestriction(MIN_LENGTH, Integer.class, 1, new MaxOperation());
        this.addRestriction(MAX_LENGTH, Integer.class, 30, new MinOperation());
        this.addConfig(LENGTH_DISTRIBUTION, String.class, "random");
    }

    public PrimitiveType getPrimitiveType() {
        if (this.primitiveType != null) {
            return this.primitiveType;
        }
        SimpleTypeDescriptor parent = this;
        while (parent.getParent() != null) {
            PrimitiveType primitiveType = PrimitiveType.getInstance(parent.getParentName());
            if (primitiveType != null) {
                this.primitiveType = primitiveType;
                return primitiveType;
            }
            parent = (SimpleTypeDescriptor)parent.getParent();
        }
        return null;
    }

    public String getMin() {
        return (String)this.getDetailValue(MIN);
    }

    public void setMin(String min) {
        this.setDetailValue(MIN, min);
    }

    public String getMax() {
        return (String)this.getDetailValue(MAX);
    }

    public void setMax(String max) {
        this.setDetailValue(MAX, max);
    }

    public String getMinExclusive() {
        return (String)this.getDetailValue(MIN_EXCLUSIVE);
    }

    public void setMinExclusive(String minExclusive) {
        this.setDetailValue(MIN, minExclusive);
    }

    public String getMaxExclusive() {
        return (String)this.getDetailValue(MAX_EXCLUSIVE);
    }

    public void setMaxExclusive(String maxExclusive) {
        this.setDetailValue(MAX_EXCLUSIVE, maxExclusive);
    }

    public String getTotalDigits() {
        return (String)this.getDetailValue(TOTAL_DIGITS);
    }

    public void setTotalDigits(String totalDigits) {
        this.setDetailValue(TOTAL_DIGITS, totalDigits);
    }

    public String getFractionDigits() {
        return (String)this.getDetailValue(FRACTION_DIGITS);
    }

    public void setFractionDigits(String fractionDigits) {
        this.setDetailValue(FRACTION_DIGITS, fractionDigits);
    }

    public String getPrecision() {
        return (String)this.getDetailValue(PRECISION);
    }

    public void setPrecision(String precision) {
        this.setDetailValue(PRECISION, precision);
    }

    public Double getTrueQuota() {
        return (Double)this.getDetailValue(TRUE_QUOTA);
    }

    public void setTrueQuota(Double trueQuota) {
        this.setDetailValue(TRUE_QUOTA, trueQuota);
    }

    public Integer getMinLength() {
        return (Integer)this.getDetailValue(MIN_LENGTH);
    }

    public void setMinLength(Integer minLength) {
        this.setDetailValue(MIN_LENGTH, minLength);
    }

    public Integer getMaxLength() {
        return (Integer)this.getDetailValue(MAX_LENGTH);
    }

    public void setMaxLength(Integer maxLength) {
        this.setDetailValue(MAX_LENGTH, maxLength);
    }

    public String getLengthDistribution() {
        return (String)this.getDetailValue(LENGTH_DISTRIBUTION);
    }

    public void setLengthDistribution(String lengthDistribution) {
        this.setDetailValue(LENGTH_DISTRIBUTION, lengthDistribution);
    }

    public SimpleTypeDescriptor withMin(String min) {
        this.setMin(min);
        return this;
    }

    public SimpleTypeDescriptor withMax(String max) {
        this.setMax(max);
        return this;
    }

    public SimpleTypeDescriptor withPrecision(String precision) {
        this.setPrecision(precision);
        return this;
    }

    public SimpleTypeDescriptor withPattern(String pattern) {
        this.setPattern(pattern);
        return this;
    }

    public SimpleTypeDescriptor withVariation1(String variation1) {
        this.setVariation1(variation1);
        return this;
    }

    public SimpleTypeDescriptor withVariation2(String variation2) {
        this.setVariation2(variation2);
        return this;
    }

    public SimpleTypeDescriptor withDistribution(String distribution) {
        this.setDistribution(distribution);
        return this;
    }

    public SimpleTypeDescriptor withDataset(String dataset) {
        this.setDataset(dataset);
        return this;
    }

    public SimpleTypeDescriptor withLocaleId(String localeId) {
        this.setLocaleId(localeId);
        return this;
    }

    public SimpleTypeDescriptor withTrueQuota(Double trueQuota) {
        this.setTrueQuota(trueQuota);
        return this;
    }

    public SimpleTypeDescriptor withUri(String source) {
        this.setSource(source);
        return this;
    }
}

