/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.data;

import java.util.Locale;
import org.databene.commons.ConfigurationError;
import org.databene.commons.LocaleUtil;
import org.databene.commons.operation.FirstNonNullSelector;
import org.databene.model.data.DataModel;
import org.databene.model.data.FeatureDescriptor;
import org.databene.model.data.FeatureDetail;
import org.databene.model.data.PrimitiveType;

public abstract class TypeDescriptor
extends FeatureDescriptor {
    public static final String VALUES = "values";
    public static final String VALIDATOR = "validator";
    public static final String GENERATOR = "generator";
    public static final String CONVERTER = "converter";
    public static final String PATTERN = "pattern";
    public static final String SCRIPT = "script";
    public static final String SOURCE = "source";
    public static final String SELECTOR = "selector";
    public static final String ENCODING = "encoding";
    public static final String SEPARATOR = "separator";
    public static final String CYCLIC = "cyclic";
    public static final String PROXY = "proxy";
    public static final String PROXY_PARAM1 = "proxy-param1";
    public static final String PROXY_PARAM2 = "proxy-param2";
    public static final String LOCALE = "locale";
    public static final String DATASET = "dataset";
    public static final String NESTING = "nesting";
    public static final String DISTRIBUTION = "distribution";
    public static final String VARIATION1 = "variation1";
    public static final String VARIATION2 = "variation2";
    protected String parentName;
    protected TypeDescriptor parent;

    public TypeDescriptor(String name) {
        this(name, (String)null);
    }

    public TypeDescriptor(String name, TypeDescriptor parent) {
        this(name, parent.getName());
        this.parent = parent;
    }

    public TypeDescriptor(String name, String parentName) {
        super(name);
        this.parentName = parentName;
        this.init();
    }

    protected void init() {
        this.addRestriction(VALIDATOR, String.class, null, new FirstNonNullSelector());
        this.addConfig(VALUES, String.class, null);
        this.addConfig(GENERATOR, String.class, null);
        this.addConfig(CONVERTER, String.class, null);
        this.addConfig(PATTERN, String.class, null);
        this.addConfig(SCRIPT, String.class, null);
        this.addConfig(SOURCE, String.class, null);
        this.addConfig(SELECTOR, String.class, null);
        this.addConfig(SEPARATOR, String.class, null);
        this.addConfig(ENCODING, String.class, null);
        this.addConfig(CYCLIC, Boolean.class, null);
        this.addConfig(PROXY, String.class, null);
        this.addConfig(PROXY_PARAM1, Long.class, null, true);
        this.addConfig(PROXY_PARAM2, Long.class, null, true);
        this.addConfig(LOCALE, Locale.class, null);
        this.addConfig(DATASET, String.class, null);
        this.addConfig(NESTING, String.class, null);
        this.addConfig(DISTRIBUTION, String.class, null);
        this.addConfig(VARIATION1, String.class, "1");
        this.addConfig(VARIATION2, String.class, "1");
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getValues() {
        return (String)this.getDetailValue(VALUES);
    }

    public void setValues(String values) {
        this.setDetailValue(VALUES, values);
    }

    public void addValue(String value) {
        this.setValues(this.getValues() + ',' + value);
    }

    public String getValidator() {
        return (String)this.getDetailValue(VALIDATOR);
    }

    public void setValidator(String validator) {
        this.setDetailValue(VALIDATOR, validator);
    }

    public String getGenerator() {
        return (String)this.getDetailValue(GENERATOR);
    }

    public void setGenerator(String generatorName) {
        this.setDetailValue(GENERATOR, generatorName);
    }

    public String getConverter() {
        return (String)this.getDetailValue(CONVERTER);
    }

    public void setConverter(String converter) {
        this.setDetailValue(CONVERTER, converter);
    }

    public String getPattern() {
        return (String)this.getDetailValue(PATTERN);
    }

    public void setPattern(String pattern) {
        this.setDetailValue(PATTERN, pattern);
    }

    public String getScript() {
        return (String)this.getDetailValue(SCRIPT);
    }

    public void setScript(String script) {
        this.setDetailValue(SCRIPT, script);
    }

    public String getSource() {
        return (String)this.getDetailValue(SOURCE);
    }

    public void setSource(String source) {
        this.setDetailValue(SOURCE, source);
    }

    public String getSelector() {
        return (String)this.getDetailValue(SELECTOR);
    }

    public void setSelector(String selector) {
        this.setDetailValue(SELECTOR, selector);
    }

    public String getSeparator() {
        return (String)this.getDetailValue(SEPARATOR);
    }

    public void setSeparator(String separator) {
        this.setDetailValue(SEPARATOR, separator);
    }

    public String getEncoding() {
        return (String)this.getDetailValue(ENCODING);
    }

    public void setEncoding(String encoding) {
        this.setDetailValue(ENCODING, encoding);
    }

    public Boolean isCyclic() {
        return (Boolean)this.getDetailValue(CYCLIC);
    }

    public void setCyclic(boolean cyclic) {
        this.setDetailValue(CYCLIC, cyclic);
    }

    public String getProxy() {
        return (String)this.getDetailValue(PROXY);
    }

    public void setProxy(String proxy) {
        this.setDetailValue(PROXY, proxy);
    }

    public Long getProxyParam1() {
        return (Long)this.getDetailValue(PROXY_PARAM1);
    }

    public void setProxyParam1(Long param) {
        this.setDetailValue(PROXY_PARAM1, param);
    }

    public Long getProxyParam2() {
        return (Long)this.getDetailValue(PROXY_PARAM2);
    }

    public void setProxyParam2(Long param) {
        this.setDetailValue(PROXY_PARAM2, param);
    }

    public String getDataset() {
        return (String)this.getDetailValue(DATASET);
    }

    public void setDataset(String dataset) {
        this.setDetailValue(DATASET, dataset);
    }

    public String getNesting() {
        return (String)this.getDetailValue(NESTING);
    }

    public void setNesting(String nesting) {
        this.setDetailValue(NESTING, nesting);
    }

    public Locale getLocale() {
        return (Locale)this.getDetailValue(LOCALE);
    }

    public void setLocaleId(String localeId) {
        this.setDetailValue(LOCALE, LocaleUtil.getLocale((String)localeId));
    }

    public String getDistribution() {
        return (String)this.getDetailValue(DISTRIBUTION);
    }

    public void setDistribution(String distribution) {
        this.setDetailValue(DISTRIBUTION, distribution);
    }

    public String getVariation1() {
        return (String)this.getDetailValue(VARIATION1);
    }

    public void setVariation1(String variation1) {
        this.setDetailValue(VARIATION1, variation1);
    }

    public String getVariation2() {
        return (String)this.getDetailValue(VARIATION2);
    }

    public void setVariation2(String variation2) {
        this.setDetailValue(VARIATION2, variation2);
    }

    public TypeDescriptor withValues(String values) {
        this.setValues(values);
        return this;
    }

    public TypeDescriptor withSource(String source) {
        this.setSource(source);
        return this;
    }

    public TypeDescriptor withSeparator(String separator) {
        this.setSeparator(separator);
        return this;
    }

    public Object getDetailValue(String name) {
        Object value = super.getDetailValue(name);
        if (value == null && this.getParent() != null && PrimitiveType.getInstance(this.parentName) == null) {
            FeatureDetail detail;
            TypeDescriptor parentDescriptor = this.getParent();
            if (parentDescriptor == null) {
                throw new ConfigurationError("Unknown type: " + this.parentName);
            }
            if (parentDescriptor.supportsDetail(name) && (detail = parentDescriptor.getDetail(name)).isRestriction()) {
                value = detail.getValue();
            }
        }
        return value;
    }

    public TypeDescriptor getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        if (this.parentName == null) {
            return null;
        }
        return DataModel.getDefaultInstance().getTypeDescriptor(this.parentName);
    }

    public void setParent(TypeDescriptor parent) {
        this.parent = parent;
    }
}

