/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.depend;

import java.util.ArrayList;
import java.util.List;
import org.databene.model.depend.Dependent;
import org.databene.model.depend.ProviderInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDependent<E extends Dependent<E>>
implements Dependent<E> {
    protected List<ProviderInfo<E>> providers = new ArrayList<ProviderInfo<E>>();

    public AbstractDependent(E ... requiredProviders) {
        for (E requiredProvider : requiredProviders) {
            this.addRequiredProvider(requiredProvider);
        }
    }

    public void addRequiredProvider(E provider) {
        this.providers.add(new ProviderInfo<E>(provider, true));
    }

    public void addOptionalProvider(E provider) {
        this.providers.add(new ProviderInfo<E>(provider, false));
    }

    @Override
    public int countProviders() {
        return this.providers.size();
    }

    @Override
    public E getProvider(int index) {
        return (E)((Dependent)this.providers.get(index).getProvider());
    }

    @Override
    public boolean requiresProvider(int index) {
        return this.providers.get(index).isRequired();
    }
}

