/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.depend;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.model.depend.CyclicDependencyException;
import org.databene.model.depend.Dependent;
import org.databene.model.depend.Node;
import org.databene.model.depend.NodeState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyModel<E extends Dependent<E>> {
    private static final Log logger = LogFactory.getLog(DependencyModel.class);
    private Map<E, Node<E>> nodeMappings = new HashMap<E, Node<E>>();

    public void addNode(E object) {
        this.nodeMappings.put(object, new Node<E>(object));
    }

    public List<E> dependencyOrderedObjects(boolean acceptingCycles) {
        for (Node<E> node : this.nodeMappings.values()) {
            E subject = node.getSubject();
            for (int i = 0; i < subject.countProviders(); ++i) {
                Object provider = subject.getProvider(i);
                Node<E> providerNode = this.nodeMappings.get(provider);
                if (providerNode == null) {
                    throw new IllegalStateException("Node is not part of model: " + provider);
                }
                providerNode.addClient(node);
                node.addProvider(providerNode, subject.requiresProvider(i));
            }
        }
        ArrayList<Node<E>> heads = new ArrayList<Node<E>>();
        ArrayList<Node<E>> tails = new ArrayList<Node<E>>();
        ArrayList<Node<Node<E>>> tmp = new ArrayList<Node<Node<E>>>(this.nodeMappings.size());
        ArrayList<Node<Node<E>>> orderedNodes = new ArrayList<Node<Node<E>>>(this.nodeMappings.size());
        ArrayList<Node<Node<E>>> incompletes = new ArrayList<Node<Node<E>>>();
        try {
            for (Node<E> node : this.nodeMappings.values()) {
                if (node.hasClients()) {
                    if (node.hasProviders()) {
                        tmp.add(node);
                        continue;
                    }
                    node.initialize();
                    heads.add(node);
                    continue;
                }
                if (node.hasProviders()) {
                    tails.add(node);
                    continue;
                }
                node.initialize();
                orderedNodes.add(node);
            }
            orderedNodes.addAll(heads);
            while (tmp.size() > 0) {
                boolean found = this.extractNodes(tmp, NodeState.INITIALIZABLE, orderedNodes, null);
                if (!found) {
                    found = this.extractNodes(tmp, NodeState.PARTIALLY_INITIALIZABLE, orderedNodes, incompletes);
                }
                if (!found) {
                    if (acceptingCycles) {
                        Node<E> node = this.findForceable(tmp);
                        logger.debug((Object)("forcing " + node));
                        tmp.remove(node);
                        node.force();
                        orderedNodes.add(node);
                        incompletes.add(node);
                    } else {
                        throw new CyclicDependencyException("Cyclic dependency in " + tmp);
                    }
                }
                this.postProcessNodes(incompletes);
            }
            if (incompletes.size() > 0) {
                throw new IllegalStateException("Incomplete nodes left: " + incompletes);
            }
            for (Node node : tails) {
                node.initialize();
            }
            orderedNodes.addAll(tails);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ordered to " + orderedNodes));
            }
            ArrayList result = new ArrayList(orderedNodes.size());
            for (Node node : orderedNodes) {
                Object subject = node.getSubject();
                if (node.getState() != NodeState.INITIALIZED) {
                    throw new IllegalStateException("Node '" + subject + "' is expected to be in INITIALIZED state, found: " + (Object)((Object)node.getState()));
                }
                result.add(subject);
            }
            return result;
        }
        catch (RuntimeException e) {
            if (!(e instanceof CyclicDependencyException)) {
                this.logState(tmp);
            }
            throw e;
        }
    }

    private void postProcessNodes(List<Node<E>> nodes) {
        Iterator<Node<E>> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            Node<E> node = iterator.next();
            switch (node.getState()) {
                case PARTIALLY_INITIALIZABLE: {
                    node.initializePartially();
                    break;
                }
                case INITIALIZED: {
                    node.initializePartially();
                    break;
                }
                case INITIALIZABLE: {
                    node.initialize();
                    iterator.remove();
                }
            }
        }
    }

    private boolean extractNodes(List<Node<E>> source, NodeState requiredState, List<Node<E>> target, List<Node<E>> incompletes) {
        boolean found = false;
        Iterator<Node<E>> iterator = source.iterator();
        while (iterator.hasNext()) {
            Node<E> node = iterator.next();
            if (node.getState() != requiredState) continue;
            iterator.remove();
            switch (requiredState) {
                case INITIALIZABLE: {
                    node.initialize();
                    break;
                }
                case PARTIALLY_INITIALIZABLE: {
                    node.initializePartially();
                    if (incompletes == null) break;
                    incompletes.add(node);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("state not supported: " + (Object)((Object)requiredState));
                }
            }
            if (target != null) {
                target.add(node);
            }
            found = true;
        }
        return found;
    }

    private void logState(List<Node<E>> intermediates) {
        logger.error((Object)(intermediates.size() + " unresolved intermediates on DependencyModel error: "));
        for (Node<E> node : intermediates) {
            logger.error(node);
        }
    }

    private Node<E> findForceable(List<Node<E>> candidates) {
        for (Node<E> candidate : candidates) {
            if (candidate.getState() != NodeState.FORCEABLE) continue;
            return candidate;
        }
        return candidates.get(0);
    }
}

