/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.depend;

import java.util.ArrayList;
import java.util.List;
import org.databene.model.depend.Dependent;
import org.databene.model.depend.NodeState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Node<E extends Dependent<E>> {
    private NodeState state;
    private E subject;
    private List<Node<E>> providers;
    private List<Boolean> providerRequired;
    private List<Node<E>> clients;

    public Node(E subject) {
        this.subject = subject;
        this.providers = new ArrayList<Node<E>>();
        this.providerRequired = new ArrayList<Boolean>();
        this.clients = new ArrayList<Node<E>>();
        this.state = NodeState.INITIALIZABLE;
    }

    public E getSubject() {
        return this.subject;
    }

    public NodeState getState() {
        return this.state;
    }

    public boolean requires(Node<E> provider) {
        return this.providerRequired.get(this.providers.indexOf(provider));
    }

    public List<Node<E>> getProviders() {
        return this.providers;
    }

    public Node<E> addProvider(Node<E> provider, boolean required) {
        this.state = NodeState.INACTIVE;
        if (this.providers.contains(provider)) {
            if (required && !this.required(provider)) {
                this.providerRequired.set(this.providers.indexOf(provider), Boolean.TRUE);
                this.providersChanged();
            }
        } else {
            this.providers.add(provider);
            this.providerRequired.add(required);
            provider.addClient(this);
            this.providersChanged();
        }
        return this;
    }

    public boolean hasProviders() {
        return this.providers.size() > 0;
    }

    public boolean required(Node<E> provider) {
        return this.providerRequired.get(this.providers.indexOf(provider));
    }

    public List<Node<E>> getClients() {
        return this.clients;
    }

    public void addClient(Node<E> client) {
        if (!this.clients.contains(client)) {
            this.clients.add(client);
        }
    }

    public boolean hasClients() {
        return this.clients.size() > 0;
    }

    void providersChanged() {
        if (this.state == NodeState.INITIALIZABLE || this.state == NodeState.INITIALIZED) {
            return;
        }
        boolean initializable = true;
        boolean partiallyInitializable = true;
        for (Node<E> provider : this.providers) {
            if (this.allowsClientInitialization(provider.getState())) continue;
            initializable = false;
            if (!this.required(provider)) continue;
            partiallyInitializable = false;
        }
        if (initializable) {
            this.state = NodeState.INITIALIZABLE;
            return;
        }
        if (this.state == NodeState.PARTIALLY_INITIALIZED) {
            return;
        }
        if (partiallyInitializable) {
            this.state = NodeState.PARTIALLY_INITIALIZABLE;
            return;
        }
        if (this.state != NodeState.INACTIVE) {
            return;
        }
        if (!this.hasProviders()) {
            this.state = NodeState.FORCEABLE;
        }
        for (Node<E> provider : this.providers) {
            if (provider.getState() != NodeState.INITIALIZED) continue;
            this.state = NodeState.FORCEABLE;
            return;
        }
    }

    private boolean allowsClientInitialization(NodeState providerState) {
        return providerState == NodeState.INITIALIZED || providerState == NodeState.FORCED || providerState == NodeState.PARTIALLY_INITIALIZED;
    }

    public void initialize() {
        if (this.state != NodeState.INITIALIZABLE) {
            throw new IllegalStateException("Node not initializable: " + this);
        }
        this.setState(NodeState.INITIALIZED);
    }

    private void setState(NodeState state) {
        this.state = state;
        for (Node<E> client : this.clients) {
            client.providersChanged();
        }
    }

    public void initializePartially() {
        if (this.state != NodeState.PARTIALLY_INITIALIZABLE) {
            throw new IllegalStateException("Node not partially initializable: " + this);
        }
        this.setState(NodeState.PARTIALLY_INITIALIZED);
    }

    public void force() {
        this.setState(NodeState.FORCED);
    }

    void assertState(NodeState state) {
        if (this.state != state) {
            throw new IllegalStateException("Expected to be in state '" + (Object)((Object)state) + "', " + "found: '" + (Object)((Object)this.state) + "'");
        }
    }

    public int hashCode() {
        return this.subject.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Node that = (Node)obj;
        return this.subject != null ? this.subject.equals(that.subject) : that.subject == null;
    }

    public String toString() {
        return this.subject.toString();
    }
}

