/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.function;

import org.databene.commons.Converter;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.accessor.FeatureAccessor;
import org.databene.commons.converter.AnyConverter;
import org.databene.model.function.IndividualWeight;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureWeight<E>
implements IndividualWeight<E> {
    private FeatureAccessor<Object, Double> accessor;
    private Converter<Object, Double> converter;

    public FeatureWeight() {
        this("weight");
    }

    public FeatureWeight(String weightFeature) {
        this.accessor = new FeatureAccessor(weightFeature);
        this.converter = new AnyConverter(Double.class);
    }

    public String getWeightFeature() {
        return this.accessor.getFeatureName();
    }

    public void setWeightFeature(String weightFeature) {
        this.accessor.setFeatureName(weightFeature);
    }

    @Override
    public double weight(E object) {
        return (Double)this.converter.convert(this.accessor.getValue(object));
    }

    public int hashCode() {
        return this.accessor.getFeatureName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureWeight that = (FeatureWeight)obj;
        return NullSafeComparator.equals((Object)this.getWeightFeature(), (Object)that.getWeightFeature());
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + (this.accessor != null ? this.accessor.getFeatureName() : "null") + ']';
    }
}

