/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.function;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.databene.commons.ConfigurationError;
import org.databene.model.function.Distribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sequence
implements Distribution {
    private static Map<String, Sequence> instances = new HashMap<String, Sequence>();
    public static final Sequence RANDOM = new Sequence("random");
    public static final Sequence SHUFFLE = new Sequence("shuffle");
    public static final Sequence CUMULATED = new Sequence("cumulated");
    public static final Sequence RANDOM_WALK = new Sequence("randomWalk");
    public static final Sequence STEP = new Sequence("step");
    public static final Sequence WEDGE = new Sequence("wedge");
    public static final Sequence BIT_REVERSE = new Sequence("bitreverse");
    private String name;

    public Sequence(String name) {
        instances.put(name, this);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sequence that = (Sequence)obj;
        return this.name.equals(that.name);
    }

    public static Sequence getInstance(String name, boolean required) {
        Sequence sequence = instances.get(name);
        if (sequence == null && required) {
            throw new ConfigurationError("Sequence not defined: " + name);
        }
        return sequence;
    }

    public static Collection<Sequence> getInstances() {
        return instances.values();
    }
}

