/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.function;

import org.databene.benerator.parser.BasicParser;
import org.databene.commons.Context;
import org.databene.commons.ConversionException;
import org.databene.commons.StringUtil;
import org.databene.commons.bean.ClassProvider;
import org.databene.commons.converter.AbstractBidirectionalConverter;
import org.databene.model.function.Distribution;
import org.databene.model.function.FeatureWeight;
import org.databene.model.function.Sequence;
import org.databene.model.function.WeightFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class String2DistributionConverter
extends AbstractBidirectionalConverter<String, Distribution> {
    private static BasicParser parser;

    public String2DistributionConverter() {
        super(String.class, Distribution.class);
        parser = new BasicParser();
    }

    public Distribution convert(String sourceValue) throws ConversionException {
        return String2DistributionConverter.parse(sourceValue, null, null);
    }

    public String revert(Distribution target) throws ConversionException {
        if (target instanceof Sequence) {
            return ((Sequence)target).getName();
        }
        if (target instanceof WeightFunction) {
            return target.getClass().getName();
        }
        throw new UnsupportedOperationException("Not a supported distribution type: " + target);
    }

    public static Distribution parse(String sourceValue, ClassProvider classProvider, Context context) throws ConversionException {
        if (StringUtil.isEmpty((String)sourceValue)) {
            return null;
        }
        if (sourceValue.startsWith("weighted[") && sourceValue.endsWith("]")) {
            return new FeatureWeight(sourceValue.substring("weighted[".length(), sourceValue.length() - 1));
        }
        if ("weighted".equals(sourceValue)) {
            return new FeatureWeight(null);
        }
        Distribution result = Sequence.getInstance(sourceValue, false);
        if (result == null) {
            result = (Distribution)parser.resolveConstructionOrReference(sourceValue, classProvider, context);
        }
        if (result == null) {
            throw new ConversionException("Distribution not found: " + sourceValue);
        }
        return result;
    }
}

