/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.version;

import java.util.HashMap;
import java.util.Map;
import org.databene.commons.comparator.IntComparator;
import org.databene.model.version.NumberVersionNumberComponent;
import org.databene.model.version.VersionNumberComponent;

public class StringVersionNumberComponent
extends VersionNumberComponent {
    static final String[] KEY_ORDER = new String[]{"alpha", "beta", "rc", "cr", "final", "ga", "sp"};
    static final Map<String, Integer> ordinals = new HashMap<String, Integer>();
    static final int FINAL_INDEX;
    static final int SP_INDEX;
    private String key;

    public StringVersionNumberComponent(String key) {
        this.key = key;
    }

    public int compareTo(VersionNumberComponent that) {
        int thisIndex;
        if (that == null) {
            return -1;
        }
        Integer thisIndexObject = ordinals.get(this.key.toLowerCase());
        int n = thisIndex = thisIndexObject != null ? thisIndexObject : FINAL_INDEX;
        if (that instanceof NumberVersionNumberComponent) {
            boolean number;
            boolean bl = number = ((NumberVersionNumberComponent)that).getNumber() == 0;
            if (number && thisIndex >= SP_INDEX) {
                return 1;
            }
            if (number && thisIndex >= FINAL_INDEX) {
                return 0;
            }
            return -1;
        }
        Integer thatIndexObject = ordinals.get(((StringVersionNumberComponent)that).key.toLowerCase());
        int thatIndex = thatIndexObject != null ? thatIndexObject : FINAL_INDEX;
        return IntComparator.compare((int)thisIndex, (int)thatIndex);
    }

    public String toString() {
        return this.key;
    }

    public int hashCode() {
        return this.key.toLowerCase().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringVersionNumberComponent that = (StringVersionNumberComponent)obj;
        return this.compareTo(that) == 0;
    }

    static {
        for (int i = 0; i < KEY_ORDER.length; ++i) {
            ordinals.put(KEY_ORDER[i], i);
        }
        FINAL_INDEX = ordinals.get("final");
        SP_INDEX = ordinals.get("sp");
    }
}

