/*
 * Decompiled with CFR 0.152.
 */
package org.databene.model.version;

import java.text.ParsePosition;
import java.util.Arrays;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.StringUtil;
import org.databene.model.version.NumberVersionNumberComponent;
import org.databene.model.version.StringVersionNumberComponent;
import org.databene.model.version.VersionNumberComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionNumber
implements Comparable<VersionNumber> {
    private static final NumberVersionNumberComponent ZERO_COMPONENT = new NumberVersionNumberComponent("0");
    private VersionNumberComponent[] components;
    private String[] delimiters;

    public VersionNumber(String number) {
        if (StringUtil.isEmpty((String)number)) {
            this.components = new VersionNumberComponent[]{new NumberVersionNumberComponent("1")};
            this.delimiters = new String[0];
        } else {
            String delimiter;
            ParsePosition pos = new ParsePosition(0);
            ArrayBuilder componentBuilder = new ArrayBuilder(VersionNumberComponent.class);
            ArrayBuilder delimBuilder = new ArrayBuilder(String.class);
            do {
                componentBuilder.append((Object)this.parseComponent(number, pos));
                delimiter = this.parseDelimiter(number, pos);
                if (delimiter == null) continue;
                delimBuilder.append((Object)delimiter);
            } while (delimiter != null);
            this.components = (VersionNumberComponent[])componentBuilder.toArray();
            this.delimiters = (String[])delimBuilder.toArray();
        }
    }

    public VersionNumber(Object ... components) {
        this.components = new VersionNumberComponent[components.length / 2 + 1];
        this.delimiters = new String[components.length / 2];
        for (int i = 0; i < components.length; i += 2) {
            Object component = components[i];
            this.components[i / 2] = component instanceof Number ? new NumberVersionNumberComponent(((Number)component).intValue()) : new StringVersionNumberComponent((String)component);
            if (i / 2 >= this.delimiters.length) continue;
            this.delimiters[i / 2] = (String)components[i + 1];
        }
    }

    private String parseDelimiter(String number, ParsePosition pos) {
        int index = pos.getIndex();
        if (index >= number.length()) {
            return null;
        }
        char c = number.charAt(index);
        if (c == '.' || c == '-' || c == '_') {
            pos.setIndex(pos.getIndex() + 1);
            return String.valueOf(c);
        }
        return "";
    }

    private VersionNumberComponent parseComponent(String number, ParsePosition pos) {
        char c = number.charAt(pos.getIndex());
        if (Character.isDigit(c)) {
            return new NumberVersionNumberComponent(this.parseNonNegativeInteger(number, pos));
        }
        return new StringVersionNumberComponent(this.parseLetters(number, pos));
    }

    private String parseNonNegativeInteger(String number, ParsePosition pos) {
        char c;
        int index;
        StringBuffer result = new StringBuffer(2);
        for (index = pos.getIndex(); index < number.length() && Character.isDigit(c = number.charAt(index)); ++index) {
            result.append(c);
        }
        pos.setIndex(index);
        return result.toString();
    }

    private String parseLetters(String number, ParsePosition pos) {
        char c;
        int index;
        StringBuffer result = new StringBuffer(10);
        for (index = pos.getIndex(); index < number.length() && Character.isLetter(c = number.charAt(index)); ++index) {
            result.append(c);
        }
        pos.setIndex(index);
        return result.toString();
    }

    @Override
    public int compareTo(VersionNumber that) {
        int n = Math.min(this.components.length, that.components.length);
        for (int i = 0; i < n; ++i) {
            int componentComparation = this.components[i].compareTo(that.components[i]);
            if (componentComparation == 0) continue;
            return componentComparation;
        }
        if (this.components.length == that.components.length) {
            return 0;
        }
        if (this.components.length < that.components.length) {
            return -this.checkAdditionalComponents(that.components, this.components.length);
        }
        return this.checkAdditionalComponents(this.components, that.components.length);
    }

    private int checkAdditionalComponents(VersionNumberComponent[] components, int from) {
        for (int i = from; i < components.length; ++i) {
            int comparation = components[i].compareTo(ZERO_COMPONENT);
            if (comparation == 0) continue;
            return comparation;
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.components.length; ++i) {
            builder.append(this.components[i]);
            if (i >= this.delimiters.length) continue;
            builder.append(this.delimiters[i]);
        }
        return builder.toString();
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.components) + Arrays.hashCode(this.delimiters);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionNumber other = (VersionNumber)obj;
        return Arrays.equals(this.components, other.components) && Arrays.equals(this.delimiters, other.delimiters);
    }
}

