/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.array;

import org.databene.commons.ArrayFormat;
import org.databene.commons.Escalator;
import org.databene.commons.LoggerEscalator;
import org.databene.commons.converter.FixedSourceTypeConverter;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Array2EntityConverter
extends FixedSourceTypeConverter<Object[], Entity> {
    private ComplexTypeDescriptor descriptor;
    private String[] attributeNames;
    Escalator escalator = new LoggerEscalator();

    public Array2EntityConverter(ComplexTypeDescriptor descriptor, String[] featureNames) {
        super(Object[].class, Entity.class);
        this.descriptor = descriptor;
        this.attributeNames = featureNames;
    }

    public Entity convert(Object[] sourceValue) {
        int length;
        Entity entity = new Entity(this.descriptor, new Object[0]);
        if (sourceValue.length > this.attributeNames.length) {
            this.escalator.escalate("Row has more columns than specified in the file header", (Object)this, (Object)sourceValue);
            length = this.attributeNames.length;
        } else {
            length = sourceValue.length;
        }
        for (int i = 0; i < length; ++i) {
            String featureName = this.attributeNames[i];
            entity.setComponent(featureName, sourceValue[i]);
        }
        return entity;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + '[' + ArrayFormat.format((String)", ", (Object[])this.attributeNames) + ']';
    }
}

