/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.csv;

import java.io.IOException;
import org.databene.commons.ConversionException;
import org.databene.commons.HeavyweightIterator;
import org.databene.document.csv.CSVTokenType;
import org.databene.document.csv.CSVTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVCellIterator
implements HeavyweightIterator<String> {
    private String uri;
    private char separator;
    private CSVTokenizer tokenizer;

    public CSVCellIterator(String uri, char separator) throws IOException {
        this.uri = uri;
        this.separator = separator;
        this.tokenizer = new CSVTokenizer(uri, separator);
        this.skipEOLs();
    }

    public String getUri() {
        return this.uri;
    }

    public char getSeparator() {
        return this.separator;
    }

    public boolean hasNext() {
        return this.tokenizer != null;
    }

    public String next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("No 'next' element available. Check availability by hasNext() before calling next().");
        }
        if (this.tokenizer.ttype == CSVTokenType.EOF) {
            throw new IllegalStateException("Ieration is finished");
        }
        try {
            String result = this.tokenizer.cell;
            this.skipEOLs();
            if (this.tokenizer.ttype == CSVTokenType.EOF) {
                this.close();
            }
            return result;
        }
        catch (ConversionException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("Operation not supported: remove()");
    }

    public void close() {
        if (this.tokenizer != null) {
            this.tokenizer.close();
            this.tokenizer = null;
        }
    }

    private void skipEOLs() {
        try {
            do {
                this.tokenizer.next();
            } while (this.tokenizer.ttype == CSVTokenType.EOL);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

