/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.csv;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ArrayUtil;
import org.databene.commons.BeanUtil;
import org.databene.commons.CollectionUtil;
import org.databene.commons.Escalator;
import org.databene.commons.LoggerEscalator;
import org.databene.commons.StringUtil;
import org.databene.model.consumer.TextFileExporter;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.ComponentDescriptor;
import org.databene.model.data.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVEntityExporter
extends TextFileExporter<Entity> {
    private static final Log logger = LogFactory.getLog(CSVEntityExporter.class);
    private static final Escalator escalator = new LoggerEscalator();
    private static final String DEFAULT_LINE_SEPARATOR = "\r\n";
    private static final char DEFAULT_SEPARATOR = ',';
    private static final String DEFAULT_URI = "export.csv";
    private String[] columns;
    private char separator;

    public CSVEntityExporter() {
        this(DEFAULT_URI, (String)null);
    }

    public CSVEntityExporter(String uri, String columns) {
        this(uri, columns, ',', null, DEFAULT_LINE_SEPARATOR);
    }

    public CSVEntityExporter(String uri, String columns, char separator, String encoding, String lineSeparator) {
        super(uri, encoding, lineSeparator);
        this.setColumns(columns);
        this.separator = separator;
    }

    public CSVEntityExporter(ComplexTypeDescriptor descriptor) {
        this(descriptor.getName() + ".csv", descriptor);
    }

    public CSVEntityExporter(String uri, ComplexTypeDescriptor descriptor) {
        this(uri, descriptor, ',', null, DEFAULT_LINE_SEPARATOR);
    }

    public CSVEntityExporter(String uri, ComplexTypeDescriptor descriptor, char separator, String encoding, String lineSeparator) {
        super(uri, encoding, lineSeparator);
        List<ComponentDescriptor> componentDescriptors = descriptor.getComponents();
        List componentNames = BeanUtil.extractProperties(componentDescriptors, (String)"name");
        this.columns = (String[])CollectionUtil.toArray((Collection)componentNames, String.class);
        this.separator = separator;
    }

    @Deprecated
    public void setProperties(String properties) {
        escalator.escalate("Property 'properties' of " + this.getClass().getName() + " has been deprecated. " + "Use property 'columns' instead.", (Object)this, (Object)properties);
        this.setColumns(properties);
    }

    public void setColumns(String columnsSpec) {
        if (StringUtil.isEmpty((String)columnsSpec)) {
            this.columns = null;
        } else {
            this.columns = StringUtil.tokenize((String)columnsSpec, (char)',');
            StringUtil.trimAll((String[])this.columns);
        }
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    @Override
    protected void startConsumingImpl(Entity entity) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("exporting " + entity));
        }
        if (ArrayUtil.isEmpty((Object[])this.columns)) {
            this.columns = (String[])CollectionUtil.toArray(entity.getComponents().keySet());
            this.printHeaderRow();
        }
        this.printer.println();
        for (int i = 0; i < this.columns.length; ++i) {
            Object value;
            String s;
            if (i > 0) {
                this.printer.print(this.separator);
            }
            if ((s = this.plainConverter.convert(value = entity.getComponent(this.columns[i]))).indexOf(this.separator) >= 0) {
                s = '\"' + s + '\"';
            }
            this.printer.print(s);
        }
    }

    @Override
    protected void postInitPrinter() {
        if (!this.append) {
            this.printHeaderRow();
        }
    }

    private void printHeaderRow() {
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                if (i > 0) {
                    this.printer.print(this.separator);
                }
                this.printer.print(this.columns[i]);
            }
        }
    }
}

