/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.csv;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;
import org.databene.commons.HeavyweightIterator;
import org.databene.commons.SystemInfo;
import org.databene.commons.converter.ArrayConverter;
import org.databene.commons.converter.ConverterChain;
import org.databene.commons.converter.NoOpConverter;
import org.databene.commons.iterator.ConvertingIterator;
import org.databene.document.csv.CSVLineIterator;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.Entity;
import org.databene.platform.array.Array2EntityConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVEntityIterator
implements HeavyweightIterator<Entity> {
    private String uri;
    private char separator;
    private String encoding;
    private HeavyweightIterator<Entity> source;
    private ComplexTypeDescriptor entityDescriptor;

    public CSVEntityIterator(String uri, String entityName) throws FileNotFoundException {
        this(uri, entityName, ',', SystemInfo.getFileEncoding());
    }

    public CSVEntityIterator(String uri, String entityName, char separator) throws FileNotFoundException {
        this(uri, entityName, separator, SystemInfo.getFileEncoding());
    }

    public CSVEntityIterator(String uri, String entityName, char separator, String encoding) throws FileNotFoundException {
        this(uri, new ComplexTypeDescriptor(entityName), (Converter<String, String>)new NoOpConverter(), separator, encoding);
    }

    public CSVEntityIterator(String uri, String entityName, Converter<String, String> preprocessor, char separator, String encoding) throws FileNotFoundException {
        this(uri, new ComplexTypeDescriptor(entityName), preprocessor, separator, encoding);
    }

    public CSVEntityIterator(String uri, ComplexTypeDescriptor descriptor, Converter<String, String> preprocessor, char separator, String encoding) throws FileNotFoundException {
        this.uri = uri;
        this.separator = separator;
        this.encoding = encoding;
        this.entityDescriptor = descriptor;
        this.init(uri, preprocessor, separator, encoding);
    }

    public void remove() {
        this.source.remove();
    }

    public boolean hasNext() {
        return this.source.hasNext();
    }

    public Entity next() {
        if (!this.source.hasNext()) {
            throw new IllegalStateException("No more entity to fetch, check hasNext() before calling next()");
        }
        return (Entity)this.source.next();
    }

    public void close() {
        this.source.close();
    }

    public static List<Entity> parseAll(String uri, char separator, String encoding, ComplexTypeDescriptor descriptor, Converter<String, String> preprocessor) throws FileNotFoundException {
        ArrayList<Entity> list = new ArrayList<Entity>();
        CSVEntityIterator iterator = new CSVEntityIterator(uri, descriptor, preprocessor, separator, encoding);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public String getUri() {
        return this.uri;
    }

    public char getSeparator() {
        return this.separator;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getEntityName() {
        return this.entityDescriptor.getName();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[uri=" + this.uri + ", encoding=" + this.encoding + ", separator=" + this.separator + ", entityName=" + this.entityDescriptor.getName() + "]";
    }

    private void init(String uri, Converter<String, String> preprocessor, char separator, String encoding) throws FileNotFoundException {
        try {
            CSVLineIterator cellIterator = new CSVLineIterator(uri, separator, true, encoding);
            if (!cellIterator.hasNext()) {
                throw new ConfigurationError("empty CSV file");
            }
            String[] featureNames = (String[])cellIterator.next();
            ArrayConverter arrayConverter = new ArrayConverter(String.class, String.class, new Converter[]{preprocessor});
            Array2EntityConverter a2eConverter = new Array2EntityConverter(this.entityDescriptor, featureNames);
            ConverterChain converter = new ConverterChain(new Converter[]{arrayConverter, a2eConverter});
            this.source = new ConvertingIterator((Iterator)cellIterator, (Converter)converter);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("Error in processing " + uri, e);
        }
    }
}

