/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.csv;

import java.io.FileNotFoundException;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;
import org.databene.commons.HeavyweightIterator;
import org.databene.commons.SystemInfo;
import org.databene.commons.converter.NoOpConverter;
import org.databene.model.data.AbstractEntitySource;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.Entity;
import org.databene.platform.csv.CSVEntityIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVEntitySource
extends AbstractEntitySource {
    private String uri;
    private char separator;
    private String encoding;
    private Converter<String, String> preprocessor;
    private ComplexTypeDescriptor entityDescriptor;

    public CSVEntitySource() {
        this(null, null);
    }

    public CSVEntitySource(String uri, String entityName) {
        this(uri, entityName, ',', SystemInfo.getFileEncoding());
    }

    public CSVEntitySource(String uri, String entityName, char separator) {
        this(uri, entityName, separator, SystemInfo.getFileEncoding());
    }

    public CSVEntitySource(String uri, String entityName, char separator, String encoding) {
        this(uri, new ComplexTypeDescriptor(entityName), (Converter<String, String>)new NoOpConverter(), separator, encoding);
    }

    public CSVEntitySource(String uri, String entityName, Converter<String, String> preprocessor, char separator, String encoding) {
        this(uri, new ComplexTypeDescriptor(entityName), preprocessor, separator, encoding);
    }

    public CSVEntitySource(String uri, ComplexTypeDescriptor descriptor, Converter<String, String> preprocessor, char separator, String encoding) {
        this.uri = uri;
        this.separator = separator;
        this.encoding = encoding;
        this.entityDescriptor = descriptor;
        this.preprocessor = preprocessor;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEntityName() {
        return this.entityDescriptor.getName();
    }

    public void setEntityName(String entityName) {
        this.entityDescriptor = new ComplexTypeDescriptor(entityName);
    }

    public HeavyweightIterator<Entity> iterator() {
        try {
            return new CSVEntityIterator(this.uri, this.entityDescriptor, this.preprocessor, this.separator, this.encoding);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationError("Cannot create iterator. ", (Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[uri=" + this.uri + ", encoding=" + this.encoding + ", separator=" + this.separator + ", entityName=" + this.entityDescriptor.getName() + "]";
    }
}

