/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.PooledConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ArrayFormat;
import org.databene.commons.BeanUtil;
import org.databene.commons.CollectionUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.ConnectFailedException;
import org.databene.commons.Context;
import org.databene.commons.Converter;
import org.databene.commons.IOUtil;
import org.databene.commons.ImportFailedException;
import org.databene.commons.ObjectNotFoundException;
import org.databene.commons.OrderedMap;
import org.databene.commons.StringUtil;
import org.databene.commons.TypedIterable;
import org.databene.commons.bean.ArrayPropertyExtractor;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.commons.converter.AnyConverter;
import org.databene.commons.converter.ConvertingIterable;
import org.databene.commons.db.DBUtil;
import org.databene.id.IdProvider;
import org.databene.id.IdProviderFactory;
import org.databene.id.IdProviderId;
import org.databene.id.IdStrategy;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.ComponentDescriptor;
import org.databene.model.data.Entity;
import org.databene.model.data.IdDescriptor;
import org.databene.model.data.Mode;
import org.databene.model.data.PartDescriptor;
import org.databene.model.data.ReferenceDescriptor;
import org.databene.model.data.SimpleTypeDescriptor;
import org.databene.model.data.TypeDescriptor;
import org.databene.model.data.TypeMapper;
import org.databene.model.depend.DependencyModel;
import org.databene.model.storage.StorageSystem;
import org.databene.model.version.VersionNumber;
import org.databene.platform.db.ColumnInfo;
import org.databene.platform.db.DatabaseDialect;
import org.databene.platform.db.EntityResultSetIterable;
import org.databene.platform.db.JdbcMetaTypeMapper;
import org.databene.platform.db.LongQueryIdProvider;
import org.databene.platform.db.PooledConnectionHandler;
import org.databene.platform.db.QueryIdProvider;
import org.databene.platform.db.QueryIterable;
import org.databene.platform.db.ResultSetConverter;
import org.databene.platform.db.SeqHiLoIdProvider;
import org.databene.platform.db.dialect.UnknownDialect;
import org.databene.platform.db.model.DBCatalog;
import org.databene.platform.db.model.DBColumn;
import org.databene.platform.db.model.DBColumnType;
import org.databene.platform.db.model.DBConstraint;
import org.databene.platform.db.model.DBForeignKeyColumn;
import org.databene.platform.db.model.DBForeignKeyConstraint;
import org.databene.platform.db.model.DBPrimaryKeyConstraint;
import org.databene.platform.db.model.DBSchema;
import org.databene.platform.db.model.DBTable;
import org.databene.platform.db.model.Database;
import org.databene.platform.db.model.jdbc.JDBCDBImporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSystem
implements StorageSystem,
IdProviderFactory {
    private static final int DEFAULT_FETCH_SIZE = 100;
    private static final VersionNumber MIN_ORACLE_VERSION = new VersionNumber("10.2.0.4");
    protected static final ArrayPropertyExtractor<String> nameExtractor = new ArrayPropertyExtractor("name", String.class);
    public static final IdStrategy<Long> SEQHILO = new IdStrategy<Long>("seqhilo", Long.class);
    public static final IdStrategy<Long> SEQUENCE = new IdStrategy<Long>("sequence", Long.class);
    public static final IdStrategy<Object> QUERY = new IdStrategy<Object>("query", Object.class);
    private static final IdStrategy[] ID_STRATEGIES = new IdStrategy[]{SEQHILO, SEQUENCE, QUERY};
    private static final TypeDescriptor[] EMPTY_TYPE_DESCRIPTOR_ARRAY = new TypeDescriptor[0];
    private String id;
    private String url;
    private String user;
    private String password;
    private String driver;
    private String schema;
    boolean batch;
    boolean readOnly;
    private int fetchSize;
    private Database database;
    private Map<Thread, ThreadContext> contexts;
    private Map<String, TypeDescriptor> typeDescriptors;
    private TypeMapper<Class<? extends Object>> driverTypeMapper;
    DatabaseDialect dialect;
    private boolean dynamicQuerySupported;
    private Map<IdProviderId, IdProvider> idProviders = new HashMap<IdProviderId, IdProvider>();
    static final Log logger = LogFactory.getLog(DBSystem.class);
    static final Log jdbcLogger = LogFactory.getLog((String)"org.databene.benerator.JDBC");

    public DBSystem() {
        this(null, null, null, null, null);
    }

    public DBSystem(String id, String url, String driver, String user, String password) {
        this.setId(id);
        this.setUrl(url);
        this.setUser(user);
        this.setPassword(password);
        this.setDriver(driver);
        this.setSchema(null);
        this.setFetchSize(100);
        this.setBatch(false);
        this.setReadOnly(false);
        this.setDynamicQuerySupported(true);
        this.typeDescriptors = null;
        this.contexts = new HashMap<Thread, ThreadContext>();
        this.driverTypeMapper = this.driverTypeMapper();
        if (driver != null && driver.contains("oracle")) {
            Connection connection = null;
            try {
                connection = this.getConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                VersionNumber driverVersion = new VersionNumber(metaData.getDriverVersion());
                if (driverVersion.compareTo(MIN_ORACLE_VERSION) < 0) {
                    logger.warn((Object)"Your Oracle driver has a bug in metadata support. Please update to 10.2.0.4 or newer. You can use that driver for accessing an Oracle 9 server as well.");
                }
            }
            catch (SQLException e) {
                throw new ConfigurationError((Throwable)e);
            }
            finally {
                this.close();
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = StringUtil.emptyToNull((String)password);
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = StringUtil.emptyToNull((String)StringUtil.trim((String)schema));
    }

    public boolean isBatch() {
        return this.batch;
    }

    public void setBatch(boolean batch) {
        this.batch = batch;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setDynamicQuerySupported(boolean dynamicQuerySupported) {
        this.dynamicQuerySupported = dynamicQuerySupported;
    }

    @Override
    public TypeDescriptor[] getTypeDescriptors() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getTypeDescriptors()");
        }
        this.parseMetadataIfNecessary();
        if (this.typeDescriptors == null) {
            return EMPTY_TYPE_DESCRIPTOR_ARRAY;
        }
        return (TypeDescriptor[])CollectionUtil.toArray(this.typeDescriptors.values(), TypeDescriptor.class);
    }

    @Override
    public TypeDescriptor getTypeDescriptor(String tableName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getTypeDescriptor(" + tableName + ")"));
        }
        this.parseMetadataIfNecessary();
        TypeDescriptor entityDescriptor = this.typeDescriptors.get(tableName);
        if (entityDescriptor == null) {
            for (TypeDescriptor candidate : this.typeDescriptors.values()) {
                if (!candidate.getName().equalsIgnoreCase(tableName)) continue;
                entityDescriptor = candidate;
                break;
            }
        }
        return entityDescriptor;
    }

    @Override
    public void store(Entity entity) {
        if (this.readOnly) {
            throw new IllegalStateException("Tried to insert rows into table '" + entity.getName() + "' " + "though database '" + this.id + "' is read-only");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Storing " + entity));
        }
        this.persistOrUpdate(entity, true);
    }

    @Override
    public void update(Entity entity) {
        if (this.readOnly) {
            throw new IllegalStateException("Tried to update table '" + entity.getName() + "' " + "though database '" + this.id + "' is read-only");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updating " + entity));
        }
        this.persistOrUpdate(entity, false);
    }

    @Override
    public void flush() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"flush()");
        }
        for (ThreadContext threadContext : this.contexts.values()) {
            threadContext.commit();
        }
    }

    @Override
    public void close() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"close()");
        }
        this.flush();
        for (IdProvider idProvider : this.idProviders.values()) {
            idProvider.close();
        }
        Iterator<ThreadContext> iterator = this.contexts.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().close();
            iterator.remove();
        }
    }

    @Override
    public TypedIterable<Entity> queryEntities(String type, String selector, Context context) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("queryEntities(" + type + ")"));
        }
        boolean script = false;
        Connection connection = this.getThreadContext().connection;
        if (selector != null && selector.startsWith("{") && selector.endsWith("}")) {
            selector = selector.substring(1, selector.length() - 1);
            script = true;
        }
        String sql = null;
        sql = StringUtil.isEmpty((String)selector) ? "select * from " + type : (StringUtil.startsWithIgnoreCase((String)selector, (String)"select") ? selector : "select * from " + type + " WHERE " + selector);
        if (script) {
            sql = '{' + sql + '}';
        }
        QueryIterable iterable = this.createQuery(sql, context, connection);
        return new EntityResultSetIterable(iterable, (ComplexTypeDescriptor)this.getTypeDescriptor(type));
    }

    public long countEntities(String tableName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("countEntities(" + tableName + ")"));
        }
        String sql = "select count(*) from " + tableName;
        try {
            Connection connection = this.getThreadContext().connection;
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            resultSet.next();
            long count = resultSet.getLong(1);
            resultSet.close();
            statement.close();
            return count;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error in counting rows of table " + tableName + ". SQL = " + sql, e);
        }
    }

    @Override
    public <T> TypedIterable<T> queryEntityIds(String tableName, String selector, Context context) {
        DBTable table;
        Object[] pkColumnNames;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getIds(" + tableName + ", " + selector + ")"));
        }
        if ((pkColumnNames = (table = this.getTable(tableName)).getPKColumnNames()).length == 0) {
            throw new ConfigurationError("Cannot create reference to table " + tableName + " since it does not define a primary key");
        }
        String query = "select " + ArrayFormat.format((Object[])pkColumnNames) + " from " + tableName;
        if (selector != null) {
            query = query + " where " + selector;
        }
        return this.query(query, context);
    }

    @Override
    public <T> TypedIterable<T> query(String query, Context context) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getBySelector(" + query + ")"));
        }
        Connection connection = this.getThreadContext().connection;
        QueryIterable resultSetIterable = this.createQuery(query, context, connection);
        return new ConvertingIterable((Iterable)((Object)resultSetIterable), (Converter)new ResultSetConverter(true));
    }

    @Override
    public IdStrategy<? extends Object>[] getIdStrategies() {
        return ID_STRATEGIES;
    }

    @Override
    public <T> IdProvider<T> idProvider(IdStrategy<T> strategy, String param, String scope) {
        IdProviderId pId = new IdProviderId(strategy.getName(), param, scope, this.getId());
        IdProvider provider = this.idProviders.get(pId);
        if (provider == null) {
            if (SEQHILO.equals(strategy)) {
                provider = new SeqHiLoIdProvider(this.getConnection(), this.dialect.sequenceAccessorSql(param), 100L);
            } else if (SEQUENCE.equals(strategy)) {
                provider = new LongQueryIdProvider(this.getConnection(), this.dialect.sequenceAccessorSql(param));
            } else if (QUERY.equals(strategy)) {
                provider = new QueryIdProvider(this.getConnection(), param);
            }
            if (provider != null) {
                this.idProviders.put(pId, provider);
            }
        }
        return provider;
    }

    public Connection createConnection() {
        try {
            Connection connection = DBUtil.connect((String)this.url, (String)this.driver, (String)this.user, (String)this.password);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            connection = (Connection)Proxy.newProxyInstance(classLoader, new Class[]{Connection.class, PooledConnection.class}, (InvocationHandler)new PooledConnectionHandler(this, connection));
            connection.setAutoCommit(false);
            return connection;
        }
        catch (ConnectFailedException e) {
            throw new RuntimeException("Connecting the database failed. URL: " + this.url, e);
        }
        catch (SQLException e) {
            throw new ConfigurationError("Turning off auto-commit failed", (Throwable)e);
        }
    }

    public void invalidate() {
        this.typeDescriptors = null;
    }

    public void parseMetaData() {
        logger.debug((Object)"parsing metadata...");
        try {
            this.typeDescriptors = new OrderedNameMap();
            JDBCDBImporter importer = new JDBCDBImporter(this.url, this.driver, this.user, this.password, this.schema, false);
            importer.setFaultTolerant(true);
            this.database = importer.importDatabase();
            String productName = importer.getProductName();
            this.mapStrategy(productName);
            List<DBTable> tables = DBSystem.dependencyOrderedTables(this.database);
            for (DBTable table : tables) {
                this.parseTable(table);
            }
        }
        catch (ConnectFailedException e) {
            throw new ConfigurationError("Database not available. ", (Throwable)e);
        }
        catch (ImportFailedException e) {
            throw new ConfigurationError("Unexpected failure of database meta data import. ", (Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.user + '@' + this.url + ']';
    }

    private QueryIterable createQuery(String query, Context context, Connection connection) {
        return new QueryIterable(connection, query, this.fetchSize, (Context)(this.dynamicQuerySupported ? context : null));
    }

    private PreparedStatement getStatement(ComplexTypeDescriptor descriptor, boolean insert, List<ColumnInfo> columnInfos) {
        ThreadContext context = this.getThreadContext();
        return context.getStatement(descriptor, insert, columnInfos);
    }

    private void mapStrategy(String productName) {
        String filename = "org/databene/platform/db/databene.db_dialect.properties";
        try {
            Map mappings = IOUtil.readProperties((String)filename);
            for (Map.Entry entry : mappings.entrySet()) {
                if (!productName.toLowerCase().contains((CharSequence)entry.getKey())) continue;
                this.dialect = (DatabaseDialect)BeanUtil.newInstance((String)((String)entry.getValue()));
                return;
            }
            this.dialect = new UnknownDialect(productName);
        }
        catch (IOException e) {
            throw new ConfigurationError("Database dialect mapping not found: " + filename, (Throwable)e);
        }
    }

    private static List<DBTable> dependencyOrderedTables(Database database) {
        DependencyModel<DBTable> model = new DependencyModel<DBTable>();
        for (DBCatalog catalog : database.getCatalogs()) {
            for (DBTable table : catalog.getTables()) {
                model.addNode(table);
            }
        }
        for (DBSchema schema : database.getSchemas()) {
            for (DBTable table : schema.getTables()) {
                model.addNode(table);
            }
        }
        List<DBTable> tables = model.dependencyOrderedObjects(true);
        return tables;
    }

    private void parseTable(DBTable table) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Parsing table " + table));
        }
        String tableName = table.getName();
        ComplexTypeDescriptor complexType = new ComplexTypeDescriptor(tableName);
        DBPrimaryKeyConstraint pkConstraint = table.getPrimaryKeyConstraint();
        Object[] columns = pkConstraint.getColumns();
        String[] pkColumnNames = (String[])ArrayPropertyExtractor.convert((Object[])columns, (String)"name", String.class);
        if (pkColumnNames.length == 1) {
            String columnName = pkColumnNames[0];
            DBColumn column = table.getColumn(columnName);
            table.getColumn(columnName);
            String abstractType = JdbcMetaTypeMapper.abstractType(column.getType());
            IdDescriptor idDescriptor = new IdDescriptor(columnName, abstractType);
            complexType.addComponent(idDescriptor);
        }
        for (DBForeignKeyConstraint constraint : table.getForeignKeyConstraints()) {
            List<DBForeignKeyColumn> foreignKeyColumns = constraint.getForeignKeyColumns();
            if (foreignKeyColumns.size() == 1) {
                DBForeignKeyColumn foreignKeyColumn = foreignKeyColumns.get(0);
                DBColumn targetColumn = foreignKeyColumn.getTargetColumn();
                DBTable targetTable = targetColumn.getTable();
                String fkColumnName = foreignKeyColumn.getForeignKeyColumn().getName();
                DBColumnType concreteType = foreignKeyColumn.getForeignKeyColumn().getType();
                String abstractType = JdbcMetaTypeMapper.abstractType(concreteType);
                ReferenceDescriptor descriptor = new ReferenceDescriptor(fkColumnName, abstractType, targetTable.getName());
                descriptor.getLocalType(false).setSource(this.id);
                descriptor.setMinCount(1L);
                descriptor.setMaxCount(1L);
                boolean nullable = foreignKeyColumn.getForeignKeyColumn().isNullable();
                descriptor.setNullable(nullable);
                complexType.setComponent(descriptor);
                logger.debug((Object)("Parsed reference " + table.getName() + '.' + descriptor));
                continue;
            }
            logger.error((Object)"Not implemented: Don't know how to handle composite foreign keys");
        }
        for (DBColumn column : table.getColumns()) {
            String columnName;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parsing column: " + column));
            }
            if (complexType.getComponent(columnName = column.getName()) != null) continue;
            String columnId = table.getName() + '.' + columnName;
            if (column.isVersionColumn()) {
                logger.debug((Object)("Leaving out version column " + columnId));
                continue;
            }
            DBColumnType columnType = column.getType();
            String type = JdbcMetaTypeMapper.abstractType(columnType);
            String defaultValue = column.getDefaultValue();
            SimpleTypeDescriptor typeDescriptor = new SimpleTypeDescriptor(columnId, type);
            if (defaultValue != null) {
                typeDescriptor.setDetailValue("values", defaultValue);
            }
            if (column.getSize() != null) {
                typeDescriptor.setMaxLength(column.getSize());
            }
            if (column.getFractionDigits() != null) {
                if ("timestamp".equals(type)) {
                    typeDescriptor.setPrecision("1970-01-02");
                } else {
                    typeDescriptor.setPrecision(this.decimalPrecision(column.getFractionDigits()));
                }
            }
            PartDescriptor descriptor = new PartDescriptor(columnName);
            descriptor.setLocalType(typeDescriptor);
            descriptor.setMinCount(1L);
            descriptor.setMaxCount(1L);
            descriptor.setNullable(column.getNotNullConstraint() == null);
            List<DBConstraint> ukConstraints = column.getUkConstraints();
            for (DBConstraint constraint : ukConstraints) {
                if (constraint.getColumns().length == 1) {
                    assert (constraint.getColumns()[0].equals(column));
                    descriptor.setUnique(true);
                    continue;
                }
                logger.warn((Object)("Automated uniqueness assurance on multiple columns is not provided yet: " + constraint));
            }
            logger.debug((Object)("parsed attribute " + columnId + ": " + descriptor));
            complexType.addComponent(descriptor);
        }
        this.typeDescriptors.put(complexType.getName(), complexType);
    }

    List<ColumnInfo> getWriteColumnInfos(Entity entity, boolean insert) {
        String tableName = entity.getName();
        DBTable table = this.getTable(tableName);
        List pkColumnNames = CollectionUtil.toList((Object[])table.getPKColumnNames());
        ComplexTypeDescriptor typeDescriptor = (ComplexTypeDescriptor)this.getTypeDescriptor(tableName);
        List<ComponentDescriptor> componentDescriptors = typeDescriptor.getComponents();
        ArrayList<ColumnInfo> pkInfos = new ArrayList<ColumnInfo>(componentDescriptors.size());
        ArrayList<ColumnInfo> normalInfos = new ArrayList<ColumnInfo>(componentDescriptors.size());
        ComplexTypeDescriptor entityDescriptor = entity.getDescriptor();
        for (ComponentDescriptor dbCompDescriptor : componentDescriptors) {
            ComponentDescriptor enCompDescriptor = entityDescriptor.getComponent(dbCompDescriptor.getName());
            if (enCompDescriptor != null && enCompDescriptor.getMode() == Mode.ignored || dbCompDescriptor.getMode() == Mode.ignored) continue;
            String name = dbCompDescriptor.getName();
            String primitiveType = ((SimpleTypeDescriptor)dbCompDescriptor.getType()).getPrimitiveType().getName();
            DBColumn column = table.getColumn(name);
            DBColumnType columnType = column.getType();
            int sqlType = columnType.getJdbcType();
            Class<? extends Object> javaType = this.driverTypeMapper.concreteType(primitiveType);
            ColumnInfo info = new ColumnInfo(name, sqlType, javaType);
            if (pkColumnNames.contains(name)) {
                pkInfos.add(info);
                continue;
            }
            normalInfos.add(info);
        }
        if (insert) {
            pkInfos.addAll(normalInfos);
            return pkInfos;
        }
        normalInfos.addAll(pkInfos);
        return normalInfos;
    }

    DBTable getTable(String tableName) {
        DBTable table;
        DBTable table2;
        this.parseMetadataIfNecessary();
        DBSchema dbSchema = this.database.getSchema(this.schema);
        if (dbSchema != null && (table2 = dbSchema.getTable(tableName)) != null) {
            return table2;
        }
        for (DBCatalog catalog : this.database.getCatalogs()) {
            table = catalog.getTable(tableName);
            if (table == null) continue;
            return table;
        }
        for (DBSchema schema2 : this.database.getSchemas()) {
            table = schema2.getTable(tableName);
            if (table == null) continue;
            return table;
        }
        throw new ObjectNotFoundException("Table " + tableName);
    }

    private synchronized ThreadContext getThreadContext() {
        Thread currentThread = Thread.currentThread();
        ThreadContext context = this.contexts.get(currentThread);
        if (context == null) {
            context = new ThreadContext();
            this.contexts.put(currentThread, context);
        }
        return context;
    }

    private Connection getConnection() {
        return this.getThreadContext().connection;
    }

    private void persistOrUpdate(Entity entity, boolean insert) {
        this.parseMetadataIfNecessary();
        List<ColumnInfo> writeColumnInfos = this.getWriteColumnInfos(entity, insert);
        try {
            String tableName = entity.getName();
            PreparedStatement statement = this.getStatement(entity.getDescriptor(), insert, writeColumnInfos);
            for (int i = 0; i < writeColumnInfos.size(); ++i) {
                ColumnInfo info = writeColumnInfos.get(i);
                Object componentValue = entity.getComponent(info.name);
                Object jdbcValue = AnyConverter.convert((Object)componentValue, info.type);
                try {
                    if (jdbcValue != null) {
                        statement.setObject(i + 1, jdbcValue);
                        continue;
                    }
                    statement.setNull(i + 1, info.sqlType);
                    continue;
                }
                catch (SQLException e) {
                    throw new RuntimeException("error setting column " + tableName + '.' + info.name, e);
                }
            }
            if (this.batch) {
                statement.addBatch();
            } else {
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error in persisting " + entity, e);
        }
    }

    private void parseMetadataIfNecessary() {
        if (this.typeDescriptors == null) {
            this.parseMetaData();
        }
    }

    private String decimalPrecision(int scale) {
        if (scale == 0) {
            return "1";
        }
        StringBuilder builder = new StringBuilder("0.");
        for (int i = 1; i < scale; ++i) {
            builder.append('0');
        }
        builder.append(1);
        return builder.toString();
    }

    private TypeMapper<Class<? extends Object>> driverTypeMapper() {
        return new TypeMapper<Class<? extends Object>>("byte", Byte.class, "short", Short.class, "int", Integer.class, "big_integer", BigInteger.class, "float", Float.class, "double", Double.class, "big_decimal", BigDecimal.class, "boolean", Boolean.class, "char", Character.class, "date", Date.class, "timestamp", Timestamp.class, "string", Clob.class, "string", String.class, "binary", Blob.class, "binary", byte[].class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThreadContext {
        Connection connection;
        public Map<ComplexTypeDescriptor, PreparedStatement> insertStatements = new OrderedMap();
        public Map<ComplexTypeDescriptor, PreparedStatement> updateStatements = new OrderedMap();

        public ThreadContext() {
            this.connection = DBSystem.this.createConnection();
        }

        void commit() {
            try {
                this.flushStatements(this.insertStatements);
                this.flushStatements(this.updateStatements);
                if (jdbcLogger.isDebugEnabled()) {
                    jdbcLogger.debug((Object)("Committing connection: " + this.connection));
                }
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        private void flushStatements(Map<ComplexTypeDescriptor, PreparedStatement> statements) throws SQLException {
            for (Map.Entry<ComplexTypeDescriptor, PreparedStatement> entry : statements.entrySet()) {
                PreparedStatement statement = entry.getValue();
                if (statement != null) {
                    if (DBSystem.this.batch) {
                        statement.executeBatch();
                    }
                    if (jdbcLogger.isDebugEnabled()) {
                        jdbcLogger.debug((Object)("Closing statement: " + statement));
                    }
                    DBUtil.close((Statement)statement);
                }
                entry.setValue(null);
            }
        }

        public PreparedStatement getStatement(ComplexTypeDescriptor descriptor, boolean insert, List<ColumnInfo> columnInfos) {
            try {
                PreparedStatement statement;
                PreparedStatement preparedStatement = statement = insert ? this.insertStatements.get(descriptor) : this.updateStatements.get(descriptor);
                if (statement == null) {
                    statement = this.createStatement(descriptor, insert, columnInfos);
                } else {
                    statement.clearParameters();
                }
                return statement;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        private PreparedStatement createStatement(ComplexTypeDescriptor descriptor, boolean insert, List<ColumnInfo> columnInfos) throws SQLException {
            String sql;
            String tableName = descriptor.getName();
            String string = sql = insert ? DBSystem.this.dialect.createSQLInsert(descriptor.getName(), columnInfos) : DBSystem.this.dialect.createSQLUpdate(tableName, DBSystem.this.getTable(tableName).getPKColumnNames(), columnInfos);
            if (jdbcLogger.isDebugEnabled()) {
                jdbcLogger.debug((Object)("Creating prepared statement: " + sql));
            }
            PreparedStatement statement = DBUtil.prepareStatement((Connection)this.connection, (String)sql, (boolean)DBSystem.this.readOnly);
            if (insert) {
                this.insertStatements.put(descriptor, statement);
            } else {
                this.updateStatements.put(descriptor, statement);
            }
            return statement;
        }

        public void close() {
            this.commit();
            DBUtil.close((Connection)this.connection);
        }
    }
}

