/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ArrayUtil;
import org.databene.platform.db.ColumnInfo;
import org.databene.platform.db.DBSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseDialect {
    private String system;
    protected boolean quoteTableNames;
    static final Log logger = LogFactory.getLog(DBSystem.class);

    public DatabaseDialect(String system, boolean quoteTableNames) {
        this.system = system;
        this.quoteTableNames = quoteTableNames;
    }

    public String sequenceAccessorSql(String sequenceName) {
        throw new UnsupportedOperationException("Sequence access not supported for " + this.system);
    }

    public String createSQLInsert(String tableName, List<ColumnInfo> columnInfos) {
        int i;
        StringBuilder builder = new StringBuilder("insert into ");
        this.appendTableName(tableName, builder).append(" (");
        if (columnInfos.size() > 0) {
            this.appendColumnName(columnInfos.get((int)0).name, builder);
        }
        for (i = 1; i < columnInfos.size(); ++i) {
            builder.append(",");
            this.appendColumnName(columnInfos.get((int)i).name, builder);
        }
        builder.append(") values (");
        if (columnInfos.size() > 0) {
            builder.append("?");
        }
        for (i = 1; i < columnInfos.size(); ++i) {
            builder.append(",?");
        }
        builder.append(")");
        String sql = builder.toString();
        logger.debug((Object)("built SQL statement: " + sql));
        return sql;
    }

    public String createSQLUpdate(String tableName, String[] pkColumnNames, List<ColumnInfo> columnInfos) {
        int i;
        if (pkColumnNames.length == 0) {
            throw new UnsupportedOperationException("Cannot update table without primary key: " + tableName);
        }
        StringBuilder builder = new StringBuilder("update ");
        this.appendTableName(tableName, builder).append(" set");
        for (i = 0; i < columnInfos.size(); ++i) {
            if (ArrayUtil.contains((Object[])pkColumnNames, (Object)columnInfos.get((int)i).name)) continue;
            builder.append(" ");
            this.appendColumnName(columnInfos.get((int)i).name, builder);
            builder.append("=?");
            if (i >= columnInfos.size() - pkColumnNames.length - 1) continue;
            builder.append(", ");
        }
        builder.append(" where");
        for (i = 0; i < pkColumnNames.length; ++i) {
            builder.append(' ');
            this.appendColumnName(pkColumnNames[i], builder);
            builder.append("=?");
            if (i >= pkColumnNames.length - 1) continue;
            builder.append(" and");
        }
        String sql = builder.toString();
        logger.debug((Object)("built SQL statement: " + sql));
        return sql;
    }

    private StringBuilder appendTableName(String tableName, StringBuilder builder) {
        if (this.quoteTableNames) {
            return builder.append('\"').append(tableName).append('\"');
        }
        return builder.append(tableName);
    }

    private StringBuilder appendColumnName(String columnName, StringBuilder builder) {
        if (this.quoteTableNames) {
            return builder.append('\"').append(columnName).append('\"');
        }
        return builder.append(columnName);
    }
}

