/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db;

import java.util.Map;
import org.databene.commons.CollectionUtil;
import org.databene.commons.ConfigurationError;
import org.databene.model.data.PrimitiveType;
import org.databene.platform.db.model.DBColumnType;

public class JdbcMetaTypeMapper {
    private static final Map TYPE_MAP = CollectionUtil.buildMap((Object[])new Object[]{-5, PrimitiveType.BIG_INTEGER, -2, PrimitiveType.BINARY, -7, PrimitiveType.BYTE, 2004, PrimitiveType.BINARY, 16, PrimitiveType.BOOLEAN, 1, PrimitiveType.STRING, 2005, PrimitiveType.STRING, 70, PrimitiveType.STRING, 91, PrimitiveType.DATE, 3, PrimitiveType.BIG_DECIMAL, 8, PrimitiveType.DOUBLE, 6, PrimitiveType.FLOAT, 4, PrimitiveType.INT, 2000, PrimitiveType.OBJECT, -4, PrimitiveType.BINARY, -1, PrimitiveType.STRING, 2, PrimitiveType.DOUBLE, 7, PrimitiveType.DOUBLE, 2006, PrimitiveType.STRING, 5, PrimitiveType.SHORT, 92, PrimitiveType.DATE, 93, PrimitiveType.TIMESTAMP, -6, PrimitiveType.BYTE, -3, PrimitiveType.BINARY, 12, PrimitiveType.STRING});

    public static String abstractType(DBColumnType columnType) {
        int jdbcType = columnType.getJdbcType();
        PrimitiveType primitiveType = (PrimitiveType)TYPE_MAP.get(jdbcType);
        if (primitiveType != null) {
            return primitiveType.getName();
        }
        String lcName = columnType.getName().toLowerCase();
        if (lcName.startsWith("timestamp")) {
            return PrimitiveType.TIMESTAMP.getName();
        }
        if (lcName.startsWith("xml")) {
            return PrimitiveType.STRING.getName();
        }
        throw new ConfigurationError("Platform specific SQL type (" + jdbcType + ") not mapped: " + jdbcType);
    }
}

