/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.db.DBUtil;

public class LoggingStatementHandler
implements InvocationHandler {
    private static final Log sqlLogger = LogFactory.getLog((String)"org.databene.SQL");
    private static final Log jdbcLogger = LogFactory.getLog((String)"org.databene.JDBC");
    private Statement realStatement;
    private boolean readOnly;
    private String sql;

    public LoggingStatementHandler(Statement realStatement, boolean readOnly) {
        this.realStatement = realStatement;
        this.readOnly = readOnly;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            String methodName = method.getName();
            Method localMethod = BeanUtil.findMethod(this.getClass(), (String)methodName, (Class[])method.getParameterTypes());
            if (localMethod != null) {
                return BeanUtil.invoke((Object)this, (Method)localMethod, (Object[])args);
            }
            return BeanUtil.invoke((Object)this.realStatement, (Method)method, (Object[])args);
        }
        catch (ConfigurationError e) {
            if (e.getCause() instanceof InvocationTargetException && e.getCause().getCause() instanceof SQLException) {
                throw e.getCause().getCause();
            }
            throw e;
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.logAll("execute", sql);
        DBUtil.checkReadOnly((String)sql, (boolean)this.readOnly);
        this.sql = sql;
        return this.realStatement.execute(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.logAll("execute", sql);
        DBUtil.checkReadOnly((String)sql, (boolean)this.readOnly);
        this.sql = sql;
        return this.realStatement.execute(sql, columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.logAll("execute", sql);
        DBUtil.checkReadOnly((String)sql, (boolean)this.readOnly);
        this.sql = sql;
        return this.realStatement.execute(sql, columnNames);
    }

    public boolean execute(String sql) throws SQLException {
        this.logAll("execute", sql);
        DBUtil.checkReadOnly((String)sql, (boolean)this.readOnly);
        this.sql = sql;
        return this.realStatement.execute(sql);
    }

    public int[] executeBatch() throws SQLException {
        jdbcLogger.debug((Object)"executeBatch()");
        return this.realStatement.executeBatch();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.logAll("executeQuery", sql);
        DBUtil.checkReadOnly((String)sql, (boolean)this.readOnly);
        this.sql = sql;
        return this.realStatement.executeQuery(sql);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.logAll("executeUpdate", sql);
        DBUtil.checkReadOnly((String)sql, (boolean)this.readOnly);
        this.sql = sql;
        return this.realStatement.executeUpdate(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.logAll("executeUpdate", sql);
        DBUtil.checkReadOnly((String)sql, (boolean)this.readOnly);
        this.sql = sql;
        return this.realStatement.executeUpdate(sql, columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.logAll("executeUpdate", sql);
        DBUtil.checkReadOnly((String)sql, (boolean)this.readOnly);
        this.sql = sql;
        return this.realStatement.executeUpdate(sql, columnNames);
    }

    public int executeUpdate(String sql) throws SQLException {
        this.logAll("executeUpdate", sql);
        DBUtil.checkReadOnly((String)sql, (boolean)this.readOnly);
        this.sql = sql;
        return this.realStatement.executeUpdate(sql);
    }

    private void logAll(String method, String sql) {
        if (jdbcLogger.isDebugEnabled()) {
            jdbcLogger.debug((Object)(method + ": " + sql));
        }
        sqlLogger.debug((Object)sql);
    }

    public String toString() {
        return this.sql;
    }
}

