/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionEventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.BeanUtil;
import org.databene.commons.db.DBUtil;
import org.databene.platform.db.DBSystem;
import org.databene.platform.db.LoggingStatementHandler;

public class PooledConnectionHandler
implements InvocationHandler {
    private static final Log jdbcLogger = LogFactory.getLog((String)"org.databene.JDBC");
    private static long nextId = 0L;
    private DBSystem db;
    private Connection realConnection;
    private long id;
    private List<ConnectionEventListener> listeners;

    public PooledConnectionHandler(DBSystem db, Connection realConnection) {
        this.db = db;
        this.id = PooledConnectionHandler.nextId();
        this.realConnection = realConnection;
        this.listeners = new ArrayList<ConnectionEventListener>();
        if (jdbcLogger.isDebugEnabled()) {
            jdbcLogger.debug((Object)("Created connection #" + this.id + ": " + realConnection));
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("close".equals(methodName)) {
            this.close();
        } else {
            if ("getConnection".equals(methodName) && args.length == 0) {
                return this.getConnection();
            }
            if ("addConnectionEventListener".equals(methodName)) {
                this.addConnectionEventListener((ConnectionEventListener)args[0]);
                return null;
            }
            if ("removeConnectionEventListener".equals(methodName)) {
                this.removeConnectionEventListener((ConnectionEventListener)args[0]);
                return null;
            }
            if ("prepareStatement".equals(methodName)) {
                switch (args.length) {
                    case 1: {
                        return DBUtil.prepareStatement((Connection)this.realConnection, (String)((String)args[0]), (boolean)this.db.isReadOnly());
                    }
                    case 2: {
                        if (method.getParameterTypes()[1] != Integer.TYPE) break;
                        return DBUtil.prepareStatement((Connection)this.realConnection, (String)((String)args[0]), (boolean)this.db.isReadOnly(), (int)((Integer)args[1]), (int)1007, (int)1);
                    }
                    case 3: {
                        return DBUtil.prepareStatement((Connection)this.realConnection, (String)((String)args[0]), (boolean)this.db.isReadOnly(), (int)((Integer)args[1]), (int)((Integer)args[2]), (int)1);
                    }
                    case 4: {
                        return DBUtil.prepareStatement((Connection)this.realConnection, (String)((String)args[0]), (boolean)this.db.isReadOnly(), (int)((Integer)args[1]), (int)((Integer)args[2]), (int)((Integer)args[3]));
                    }
                }
            } else if ("createStatement".equals(methodName)) {
                return this.createStatement(method, args);
            }
        }
        return BeanUtil.invoke((Object)this.realConnection, (Method)method, (Object[])args);
    }

    private Statement createStatement(Method method, Object[] args) {
        Statement realStatement = (Statement)BeanUtil.invoke((Object)this.realConnection, (Method)method, (Object[])args);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Statement proxy = (Statement)Proxy.newProxyInstance(classLoader, new Class[]{Statement.class}, (InvocationHandler)new LoggingStatementHandler(realStatement, this.db.isReadOnly()));
        return proxy;
    }

    public void close() throws SQLException {
        try {
            this.realConnection.close();
            this.listeners.clear();
            if (jdbcLogger.isDebugEnabled()) {
                jdbcLogger.debug((Object)("Closed connection #" + this.id + ": " + this.realConnection));
            }
        }
        catch (SQLException e) {
            jdbcLogger.error((Object)("Error closing connection #" + this.id + ": " + this.realConnection), (Throwable)e);
            throw e;
        }
    }

    public Connection getConnection() {
        return this.realConnection;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    private static synchronized long nextId() {
        return ++nextId;
    }
}

