/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.databene.commons.ConfigurationError;
import org.databene.commons.db.DBUtil;
import org.databene.id.IdProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryIdProvider
implements IdProvider<String> {
    private PreparedStatement statement;
    private String query;

    public QueryIdProvider(Connection connection, String query) {
        try {
            this.query = query;
            this.statement = connection.prepareStatement(query);
        }
        catch (SQLException e) {
            throw new ConfigurationError("Statement creation failed: " + query, (Throwable)e);
        }
    }

    public Class<String> getType() {
        return String.class;
    }

    public boolean hasNext() {
        return this.statement != null;
    }

    public String next() {
        return DBUtil.queryString((PreparedStatement)this.statement);
    }

    public void remove() {
        throw new UnsupportedOperationException("Removal is not supported.");
    }

    public void close() {
        DBUtil.close((Statement)this.statement);
        this.statement = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.query + ']';
    }
}

