/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.Context;
import org.databene.commons.Converter;
import org.databene.commons.HeavyweightIterable;
import org.databene.commons.HeavyweightIterator;
import org.databene.commons.StringUtil;
import org.databene.commons.converter.NoOpConverter;
import org.databene.platform.db.ResultSetIterator;
import org.databene.script.ScriptConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryIterable
implements HeavyweightIterable<ResultSet> {
    private static final Log sqlLogger = LogFactory.getLog((String)"org.databene.SQL");
    private static final Log logger = LogFactory.getLog(QueryIterable.class);
    private Connection connection;
    private String query;
    private int fetchSize;
    private Converter<String, ?> queryPreprocessor;
    private String renderedQuery;

    public QueryIterable(Connection connection) {
        this(connection, null, 100);
    }

    public QueryIterable(Connection connection, String query) {
        this(connection, query, 100);
    }

    public QueryIterable(Connection connection, String query, int fetchSize) {
        this(connection, query, fetchSize, null);
    }

    public QueryIterable(Connection connection, String query, int fetchSize, Context context) {
        this.connection = connection;
        this.query = query;
        this.fetchSize = fetchSize;
        this.queryPreprocessor = context != null ? new ScriptConverter(context) : new NoOpConverter();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Constructed QueryIterable: " + query));
        }
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public HeavyweightIterator<ResultSet> iterator() {
        if (this.connection == null) {
            throw new IllegalStateException("'connection' is null");
        }
        if (StringUtil.isEmpty((String)this.query)) {
            throw new IllegalStateException("'query' is empty or null");
        }
        this.renderedQuery = this.queryPreprocessor.convert((Object)this.query).toString();
        try {
            if (sqlLogger.isDebugEnabled()) {
                sqlLogger.debug((Object)this.renderedQuery);
            }
            Statement statement = this.connection.createStatement(1003, 1007, 1);
            statement.setFetchSize(this.fetchSize);
            ResultSet resultSet = statement.executeQuery(this.renderedQuery);
            return new ResultSetIterator(resultSet, this.renderedQuery);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error in query: " + this.renderedQuery, e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + (this.renderedQuery != null ? this.renderedQuery : this.query) + ']';
    }
}

