/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ConversionException;
import org.databene.commons.converter.FixedSourceTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetConverter
extends FixedSourceTypeConverter<ResultSet, Object> {
    private boolean simplifying;
    private static final Log logger = LogFactory.getLog(ResultSetConverter.class);

    public ResultSetConverter() {
        this(true);
    }

    public ResultSetConverter(boolean simplifying) {
        super(ResultSet.class, Object.class);
        this.simplifying = simplifying;
    }

    public Object convert(ResultSet resultSet) throws ConversionException {
        Object[] tmp = ResultSetConverter.convertToArray(resultSet);
        return !this.simplifying || tmp.length > 1 ? tmp : tmp[0];
    }

    public static Object convert(ResultSet resultSet, boolean simplifying) throws ConversionException {
        Object[] tmp = ResultSetConverter.convertToArray(resultSet);
        return !simplifying || tmp.length > 1 ? tmp : tmp[0];
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private static Object[] convertToArray(ResultSet resultSet) throws ConversionException {
        try {
            int columnCount = resultSet.getMetaData().getColumnCount();
            Object[] cells = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                cells[i] = resultSet.getObject(i + 1);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Converted: " + ArrayFormat.format((Object[])cells)));
            }
            return cells;
        }
        catch (SQLException e) {
            throw new ConversionException((Throwable)e);
        }
    }
}

