/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.databene.commons.HeavyweightIterator;
import org.databene.commons.converter.AnyConverter;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.ComponentDescriptor;
import org.databene.model.data.Entity;
import org.databene.model.data.SimpleTypeDescriptor;
import org.databene.platform.bean.BeanDescriptorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetEntityIterator
implements HeavyweightIterator<Entity> {
    private HeavyweightIterator<ResultSet> resultSetIterator;
    private BeanDescriptorProvider beanDescriptorProvider;
    private ComplexTypeDescriptor descriptor;

    public ResultSetEntityIterator(HeavyweightIterator<ResultSet> resultSetIterator, ComplexTypeDescriptor descriptor) {
        this.resultSetIterator = resultSetIterator;
        this.descriptor = descriptor;
        this.beanDescriptorProvider = new BeanDescriptorProvider();
    }

    public boolean hasNext() {
        return this.resultSetIterator.hasNext();
    }

    public Entity next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("No more row available. Check 'hasNext()' before calling next()!");
        }
        try {
            Entity entity = new Entity(this.descriptor, new Object[0]);
            ResultSet resultSet = (ResultSet)this.resultSetIterator.next();
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                String typeName;
                String columnName = metaData.getColumnName(columnIndex);
                if (this.descriptor != null) {
                    ComponentDescriptor component = this.descriptor.getComponent(columnName);
                    SimpleTypeDescriptor type = (SimpleTypeDescriptor)component.getType();
                    typeName = type.getPrimitiveType().getName();
                } else {
                    typeName = "string";
                }
                Object javaValue = this.javaValue(resultSet, columnIndex, typeName);
                entity.setComponent(columnName, javaValue);
            }
            return entity;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.resultSetIterator.close();
    }

    private Object javaValue(ResultSet resultSet, int columnIndex, String primitiveType) throws SQLException {
        if ("date".equals(primitiveType)) {
            return resultSet.getDate(columnIndex);
        }
        if ("timestamp".equals(primitiveType)) {
            return resultSet.getTimestamp(columnIndex);
        }
        if ("string".equals(primitiveType)) {
            return resultSet.getString(columnIndex);
        }
        Object driverValue = resultSet.getObject(columnIndex);
        Class<? extends Object> javaType = this.beanDescriptorProvider.concreteType(primitiveType);
        Object javaValue = AnyConverter.convert((Object)driverValue, javaType);
        return javaValue;
    }
}

