/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.HeavyweightIterator;
import org.databene.commons.db.DBUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetIterator
implements HeavyweightIterator<ResultSet> {
    private ResultSet resultSet;
    private Boolean hasNext;
    private String query;
    private static final Log logger = LogFactory.getLog(ResultSetIterator.class);

    public ResultSetIterator(ResultSet resultSet) {
        this(resultSet, "");
    }

    public ResultSetIterator(ResultSet resultSet, String query) {
        this.resultSet = resultSet;
        this.hasNext = null;
        this.query = query;
    }

    public boolean hasNext() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("hasNext() called on: " + this));
        }
        if (this.hasNext != null) {
            return this.hasNext;
        }
        if (this.resultSet == null) {
            return false;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("hasNext() checks resultSet availability of: " + this));
            }
            this.hasNext = this.resultSet.next();
            if (!this.hasNext.booleanValue()) {
                this.close();
            }
            return this.hasNext;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error in query: " + this.query, e);
        }
    }

    public ResultSet next() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("next() called on: " + this));
        }
        if (!this.hasNext()) {
            throw new IllegalStateException("No more row available. Use hasNext() for checking availability.");
        }
        this.hasNext = null;
        return this.resultSet;
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }

    public synchronized void close() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("closing " + this));
        }
        this.hasNext = false;
        if (this.resultSet == null) {
            return;
        }
        try {
            Statement statement = this.resultSet.getStatement();
            DBUtil.close((ResultSet)this.resultSet);
            this.resultSet = null;
            DBUtil.close((Statement)statement);
        }
        catch (SQLException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.query + ']';
    }
}

