/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db;

import java.sql.Connection;
import java.sql.SQLException;
import org.databene.commons.ErrorHandler;
import org.databene.commons.Escalator;
import org.databene.commons.LoggerEscalator;
import org.databene.commons.SystemInfo;
import org.databene.commons.db.DBUtil;
import org.databene.platform.db.DBSystem;
import org.databene.task.AbstractTask;
import org.databene.task.TaskException;

public class RunSqlScriptTask
extends AbstractTask {
    private static final String DEFAULT_ENCODING = SystemInfo.getFileEncoding();
    private static Escalator escalator = new LoggerEscalator();
    private String uri;
    private String encoding;
    private String text;
    private DBSystem db;
    private boolean ignoreComments;
    private ErrorHandler errorHandler;
    private Object result;

    public RunSqlScriptTask() {
        this(null, DEFAULT_ENCODING, null);
    }

    public RunSqlScriptTask(String uri, String encoding, DBSystem db) {
        this.uri = uri;
        this.encoding = encoding != null ? encoding : DEFAULT_ENCODING;
        this.db = db;
        this.initDefaults();
    }

    public RunSqlScriptTask(String text, DBSystem db) {
        this.text = text;
        this.db = db;
        this.initDefaults();
    }

    private void initDefaults() {
        String message = this.getClass().getName() + " is deprecated. When running benerator, use <execute> instead.";
        escalator.escalate(message, this.getClass(), null);
        this.ignoreComments = false;
        this.errorHandler = new ErrorHandler("org.databene.SQL");
        this.errorHandler.setLoggingStackTrace(false);
    }

    public void run() {
        Connection connection = null;
        try {
            connection = this.db.createConnection();
            this.result = this.text != null ? DBUtil.runScript((String)this.text, (Connection)connection, (boolean)this.ignoreComments, (ErrorHandler)this.errorHandler) : DBUtil.runScript((String)this.uri, (String)this.encoding, (Connection)connection, (boolean)this.ignoreComments, (ErrorHandler)this.errorHandler);
            this.db.invalidate();
            connection.commit();
        }
        catch (Exception sqle) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw new TaskException(sqle);
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public DBSystem getDb() {
        return this.db;
    }

    public void setDb(DBSystem db) {
        this.db = db;
    }

    @Deprecated
    public boolean isHaltOnError() {
        return this.errorHandler.getLevel() == ErrorHandler.Level.fatal;
    }

    @Deprecated
    public void setHaltOnError(boolean haltOnError) {
        this.errorHandler = new ErrorHandler("org.databene.SQL", haltOnError ? ErrorHandler.Level.fatal : ErrorHandler.Level.error);
        this.errorHandler.setLoggingStackTrace(false);
    }

    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public void setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
    }

    public Object getResult() {
        return this.result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.uri + "->" + this.db.getId() + ']';
    }
}

