/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.Assert;
import org.databene.commons.db.DBUtil;
import org.databene.model.consumer.TextFileExporter;
import org.databene.model.data.Entity;
import org.databene.platform.csv.CSVEntityExporter;
import org.databene.platform.db.ColumnInfo;
import org.databene.platform.db.DBSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLEntityExporter
extends TextFileExporter<Entity> {
    private static final Log logger = LogFactory.getLog(CSVEntityExporter.class);
    private static final String DEFAULT_URI = "export.sql";
    private DBSystem database;

    public SQLEntityExporter() {
        this(DEFAULT_URI);
    }

    public SQLEntityExporter(String uri) {
        this(uri, null);
    }

    public SQLEntityExporter(String uri, String encoding) {
        this(uri, encoding, null);
    }

    public SQLEntityExporter(String uri, String encoding, String lineSeparator) {
        super(uri, encoding, lineSeparator);
        this.setNullString("null");
        this.setDatePattern("''dd-MMM-yyyy''");
        this.setTimestampPattern("'TIMESTAMP' ''yyyy-MM-dd HH:mm:ss.SSSSSS''");
    }

    public void setDatabase(DBSystem database) {
        this.database = database;
    }

    @Override
    protected void startConsumingImpl(Entity entity) {
        Assert.notNull((Object)this.database, (String)"database");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("exporting " + entity));
        }
        List<ColumnInfo> columnInfos = this.database.getWriteColumnInfos(entity, true);
        String sql = this.createSQLInsert(entity, columnInfos);
        this.printer.println(sql);
    }

    @Override
    protected void postInitPrinter() {
    }

    String createSQLInsert(Entity entity, List<ColumnInfo> columnInfos) {
        int i;
        String table = entity.getName();
        StringBuilder builder = new StringBuilder("insert into ").append(table).append(" (");
        if (columnInfos.size() > 0) {
            builder.append(columnInfos.get((int)0).name);
        }
        for (i = 1; i < columnInfos.size(); ++i) {
            builder.append(',').append(columnInfos.get((int)i).name);
        }
        builder.append(") values (");
        for (i = 0; i < columnInfos.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            Object value = entity.get(columnInfos.get((int)i).name);
            String text = this.format(value);
            text = DBUtil.escape((String)text);
            if (value instanceof CharSequence || value instanceof Character) {
                builder.append("'").append(text).append("'");
                continue;
            }
            builder.append(text);
        }
        builder.append(");");
        String sql = builder.toString();
        logger.debug((Object)("built SQL statement: " + sql));
        return sql;
    }
}

