/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ConfigurationError;
import org.databene.commons.db.DBUtil;
import org.databene.id.IdProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqHiLoIdProvider
implements IdProvider<Long> {
    protected static final int DEFAULT_MAX_LO = 100;
    private PreparedStatement statement;
    private String selector;
    private long maxLo;
    private int lo;
    private long hi;
    private static final Log logger = LogFactory.getLog(SeqHiLoIdProvider.class);
    private static final Log sqlLogger = LogFactory.getLog((String)"org.databene.SQL");

    public SeqHiLoIdProvider(Connection connection, String selector) {
        this(connection, selector, 100L);
    }

    public SeqHiLoIdProvider(Connection connection, String selector, long maxLo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Instantiating " + this.getClass().getSimpleName() + '[' + selector + ']'));
        }
        try {
            this.selector = selector;
            this.maxLo = maxLo;
            this.statement = connection.prepareStatement(selector);
            this.hi = -1L;
            this.lo = -1;
        }
        catch (SQLException e) {
            throw new ConfigurationError("Statement creation failed: " + selector, (Throwable)e);
        }
    }

    public Class<Long> getType() {
        return Long.class;
    }

    public boolean hasNext() {
        return this.statement != null;
    }

    public Long next() {
        if (this.hi == -1L || (long)this.lo >= this.maxLo) {
            this.hi = this.nextHi();
            this.lo = 0;
        } else {
            ++this.lo;
        }
        return this.hi * (this.maxLo + 1L) + (long)this.lo;
    }

    public void remove() {
        throw new UnsupportedOperationException("Removal is not supported.");
    }

    public void close() {
        DBUtil.close((Statement)this.statement);
        this.statement = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.selector + ',' + this.maxLo + ']';
    }

    private long nextHi() {
        if (sqlLogger.isDebugEnabled()) {
            sqlLogger.debug((Object)this.selector);
        }
        return Long.parseLong(DBUtil.queryString((PreparedStatement)this.statement));
    }
}

